/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PaymentInitiationLinks
extends AbstractLinks {
    private ScaApproachResolver scaApproachResolver;
    private RedirectLinkBuilder redirectLinkBuilder;
    private RedirectIdService redirectIdService;
    private boolean explicitMethod;
    private ScaRedirectFlow scaRedirectFlow;
    private boolean authorisationConfirmationRequestMandated;

    public PaymentInitiationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body, boolean explicitMethod, boolean signingBasketModeActive, ScaRedirectFlow scaRedirectFlow, boolean authorisationConfirmationRequestMandated) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.explicitMethod = explicitMethod;
        this.scaRedirectFlow = scaRedirectFlow;
        this.authorisationConfirmationRequestMandated = authorisationConfirmationRequestMandated;
        this.buildPaymentLinks(paymentRequestParameters, body, signingBasketModeActive);
    }

    private void buildPaymentLinks(PaymentInitiationParameters paymentRequestParameters, PaymentInitiationResponse body, boolean signingBasketModeActive) {
        ScaApproach scaApproach;
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return;
        }
        String paymentService = paymentRequestParameters.getPaymentType().getValue();
        String paymentProduct = paymentRequestParameters.getPaymentProduct();
        String paymentId = body.getPaymentId();
        String authorisationId = body.getAuthorizationId();
        String internalRequestId = body.getInternalRequestId();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach scaApproach2 = scaApproach = authorisationId == null ? this.scaApproachResolver.resolveScaApproach() : this.scaApproachResolver.getScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.addEmbeddedDecoupledRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId, signingBasketModeActive);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId, internalRequestId);
        } else if (scaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth(new HrefType("scaOAuth"));
        }
    }

    private void addEmbeddedDecoupledRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId, boolean signingBasketModeActive) {
        if (this.explicitMethod) {
            if (signingBasketModeActive) {
                this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
            } else {
                this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
            }
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }

    private void addRedirectRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId, String internalRequestId) {
        if (this.explicitMethod) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations", paymentService, paymentProduct, paymentId));
        } else {
            String redirectId = this.redirectIdService.generateRedirectId(authorisationId);
            String paymentOauthLink = this.scaRedirectFlow == ScaRedirectFlow.OAUTH ? this.redirectLinkBuilder.buildPaymentScaOauthRedirectLink(paymentId, redirectId, internalRequestId) : this.redirectLinkBuilder.buildPaymentScaRedirectLink(paymentId, redirectId, internalRequestId);
            this.setScaRedirectOAuthLink(this.scaRedirectFlow, paymentOauthLink);
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            if (this.authorisationConfirmationRequestMandated) {
                this.setConfirmation(this.buildPath(this.redirectLinkBuilder.buildPisConfirmationLink(paymentService, paymentProduct, paymentId, redirectId), new Object[0]));
            }
        }
    }
}

