/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.validator.payment;

import de.adorsys.psd2.validator.payment.CountryValidatorHolder;
import de.adorsys.psd2.validator.payment.PaymentBodyFieldsValidator;
import de.adorsys.psd2.validator.payment.PaymentBusinessValidator;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CountryPaymentValidatorResolver {
    private static final String DEFAULT = "DE";
    private final Map<String, CountryValidatorHolder> countryValidators = new HashMap<String, CountryValidatorHolder>();
    private AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private List<CountryValidatorHolder> countryValidatorHolders;

    @Autowired
    public CountryPaymentValidatorResolver(AspspProfileServiceWrapper aspspProfileServiceWrapper, List<CountryValidatorHolder> countryValidatorHolders) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.countryValidatorHolders = countryValidatorHolders;
        this.initContext();
    }

    public PaymentBodyFieldsValidator getPaymentBodyFieldValidator() {
        return this.getCountryValidatorHolder().getPaymentBodyFieldsValidator();
    }

    public PaymentBusinessValidator getPaymentBusinessValidator() {
        return this.getCountryValidatorHolder().getPaymentBusinessValidator();
    }

    CountryValidatorHolder getCountryValidatorHolder() {
        String supportedPaymentCountryCode = this.aspspProfileServiceWrapper.getSupportedPaymentCountryValidation();
        return this.countryValidators.getOrDefault(StringUtils.upperCase((String)supportedPaymentCountryCode), this.countryValidators.get(DEFAULT));
    }

    private void initContext() {
        this.countryValidatorHolders.forEach(m -> {
            if (m.isCustom() || !this.countryValidators.containsKey(m.getCountryIdentifier())) {
                this.countryValidators.put(m.getCountryIdentifier(), (CountryValidatorHolder)m);
            }
        });
    }
}

