/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PisAuthorisationValidator {
    private static final Logger log = LoggerFactory.getLogger(PisAuthorisationValidator.class);

    @NotNull
    public ValidationResult validate(@NotNull String authorisationId, @NotNull PisCommonPaymentResponse commonPaymentResponse) {
        Optional authorisationOptional = commonPaymentResponse.findAuthorisationInPayment(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Payment ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data has failed: couldn't find authorisation with given authorisationId for payment", (Object)commonPaymentResponse.getExternalId(), (Object)authorisationId);
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        return ValidationResult.valid();
    }
}

