/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.status;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.mapper.MediaTypeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.status.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiGetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadPaymentStatusService
implements ReadPaymentStatusService {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadPaymentStatusService.class);
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final MediaTypeMapper mediaTypeMapper;

    public AbstractReadPaymentStatusService(SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, MediaTypeMapper mediaTypeMapper) {
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.mediaTypeMapper = mediaTypeMapper;
    }

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(CommonPaymentData commonPaymentData, SpiContextData spiContextData, @NotNull String encryptedPaymentId, String acceptMediaType) {
        if (ArrayUtils.isEmpty((byte[])commonPaymentData.getPaymentData())) {
            return new ReadPaymentStatusResponse(ErrorHolder.builder((ErrorType)ErrorType.PIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_FOUND)}).build());
        }
        Optional spiPaymentOptional = this.createSpiPayment(commonPaymentData);
        if (!spiPaymentOptional.isPresent()) {
            return new ReadPaymentStatusResponse(ErrorHolder.builder((ErrorType)ErrorType.PIS_404).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)}).build());
        }
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse<SpiGetPaymentStatusResponse> spiResponse = this.getSpiPaymentStatusById(spiContextData, acceptMediaType, spiPaymentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            return new ReadPaymentStatusResponse(errorHolder);
        }
        SpiGetPaymentStatusResponse payload = (SpiGetPaymentStatusResponse)spiResponse.getPayload();
        return new ReadPaymentStatusResponse(payload.getTransactionStatus(), payload.getFundsAvailable(), this.mediaTypeMapper.mapToMediaType(payload.getResponseContentType()), payload.getPaymentStatusRaw(), payload.getPsuMessage());
    }

    protected abstract Optional createSpiPayment(CommonPaymentData var1);

    protected abstract SpiResponse<SpiGetPaymentStatusResponse> getSpiPaymentStatusById(SpiContextData var1, String var2, Object var3, SpiAspspConsentDataProvider var4);
}

