/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.CardTransaction;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCardTransactionMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aExchangeRateMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAddressMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aCardTransactionMapperImpl
implements SpiToXs2aCardTransactionMapper {
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private Xs2aToSpiAddressMapper xs2aToSpiAddressMapper;
    @Autowired
    private SpiToXs2aExchangeRateMapper spiToXs2aExchangeRateMapper;

    @Override
    public CardTransaction mapToXs2aCardTransaction(SpiCardTransaction spiCardTransaction) {
        if (spiCardTransaction == null) {
            return null;
        }
        CardTransaction cardTransaction = new CardTransaction();
        cardTransaction.setCardTransactionId(spiCardTransaction.getCardTransactionId());
        cardTransaction.setTerminalId(spiCardTransaction.getTerminalId());
        cardTransaction.setTransactionDate(spiCardTransaction.getTransactionDate());
        cardTransaction.setAcceptorTransactionDateTime(spiCardTransaction.getAcceptorTransactionDateTime());
        cardTransaction.setBookingDate(spiCardTransaction.getBookingDate());
        cardTransaction.setTransactionAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiCardTransaction.getTransactionAmount()));
        cardTransaction.setCurrencyExchange(this.spiToXs2aExchangeRateMapper.mapToExchangeRateList(spiCardTransaction.getCurrencyExchange()));
        cardTransaction.setOriginalAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiCardTransaction.getOriginalAmount()));
        cardTransaction.setMarkupFee(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiCardTransaction.getMarkupFee()));
        cardTransaction.setMarkupFeePercentage(spiCardTransaction.getMarkupFeePercentage());
        cardTransaction.setCardAcceptorId(spiCardTransaction.getCardAcceptorId());
        cardTransaction.setCardAcceptorAddress(this.xs2aToSpiAddressMapper.mapToXs2aAddress(spiCardTransaction.getCardAcceptorAddress()));
        cardTransaction.setCardAcceptorPhone(spiCardTransaction.getCardAcceptorPhone());
        cardTransaction.setMerchantCategoryCode(spiCardTransaction.getMerchantCategoryCode());
        cardTransaction.setMaskedPAN(spiCardTransaction.getMaskedPAN());
        cardTransaction.setTransactionDetails(spiCardTransaction.getTransactionDetails());
        cardTransaction.setInvoiced(spiCardTransaction.getInvoiced());
        cardTransaction.setProprietaryBankTransactionCode(spiCardTransaction.getProprietaryBankTransactionCode());
        return cardTransaction;
    }

    @Override
    public List<CardTransaction> mapToXs2aCardTransactionList(List<SpiCardTransaction> spiCardTransaction) {
        if (spiCardTransaction == null) {
            return null;
        }
        ArrayList<CardTransaction> list = new ArrayList<CardTransaction>(spiCardTransaction.size());
        for (SpiCardTransaction spiCardTransaction1 : spiCardTransaction) {
            list.add(this.mapToXs2aCardTransaction(spiCardTransaction1));
        }
        return list;
    }
}

