/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SpiErrorMapper {
    public ErrorHolder mapToErrorHolder(SpiResponse<?> spiResponse, ServiceType serviceType) {
        List errors = spiResponse.getErrors();
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("SPI response must contain errors for mapping");
        }
        TppMessage firstTppMessage = (TppMessage)errors.get(0);
        TppMessageInformation[] tppMessages = (TppMessageInformation[])errors.stream().map(this::mapToMessageError).toArray(TppMessageInformation[]::new);
        ErrorType errorType = ErrorType.getByServiceTypeAndErrorCode((ServiceType)serviceType, (int)firstTppMessage.getErrorCode().getCode()).orElse(null);
        return ErrorHolder.builder((ErrorType)errorType).tppMessages(tppMessages).build();
    }

    private TppMessageInformation mapToMessageError(TppMessage tppMessage) {
        if (StringUtils.isBlank((CharSequence)tppMessage.getMessageText())) {
            if (ArrayUtils.isNotEmpty((Object[])tppMessage.getMessageTextArgs())) {
                return TppMessageInformation.of((MessageErrorCode)tppMessage.getErrorCode(), (Object[])tppMessage.getMessageTextArgs());
            }
            return TppMessageInformation.of((MessageErrorCode)tppMessage.getErrorCode());
        }
        return TppMessageInformation.buildWithCustomError((MessageErrorCode)tppMessage.getErrorCode(), (String)tppMessage.getMessageText());
    }
}

