/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import de.adorsys.psd2.xs2a.domain.CashAccountType;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.account.AccountStatus;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import java.beans.ConstructorProperties;
import java.util.Currency;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

public class Xs2aAccountDetails {
    private final String aspspAccountId;
    @Size(max=35)
    @NotNull
    private final @Size(max=35) @NotNull String resourceId;
    private final String iban;
    private final String bban;
    @Size(max=35)
    private final @Size(max=35) String pan;
    @Size(max=35)
    private final @Size(max=35) String maskedPan;
    @Size(max=35)
    private final @Size(max=35) String msisdn;
    @NotNull
    private final Currency currency;
    private final String name;
    private final String displayName;
    @Size(max=35)
    private final @Size(max=35) String product;
    private final CashAccountType cashAccountType;
    private final AccountStatus accountStatus;
    private final String bic;
    @Size(max=70)
    private final @Size(max=70) String linkedAccounts;
    private final Xs2aUsageType usageType;
    private final String details;
    private final List<Xs2aBalance> balances;
    private Links links = new Links();
    private final String ownerName;
    private final Xs2aAddress ownerAddress;

    @JsonIgnore
    public AccountReferenceSelector getAccountSelector() {
        if (StringUtils.isNotBlank((CharSequence)this.iban)) {
            return new AccountReferenceSelector(AccountReferenceType.IBAN, this.iban);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bban)) {
            return new AccountReferenceSelector(AccountReferenceType.BBAN, this.bban);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pan)) {
            return new AccountReferenceSelector(AccountReferenceType.PAN, this.pan);
        }
        if (StringUtils.isNotBlank((CharSequence)this.msisdn)) {
            return new AccountReferenceSelector(AccountReferenceType.MSISDN, this.msisdn);
        }
        if (StringUtils.isNotBlank((CharSequence)this.maskedPan)) {
            return new AccountReferenceSelector(AccountReferenceType.MASKED_PAN, this.maskedPan);
        }
        throw new IllegalArgumentException("At least one account reference property must be set!");
    }

    @ConstructorProperties(value={"aspspAccountId", "resourceId", "iban", "bban", "pan", "maskedPan", "msisdn", "currency", "name", "displayName", "product", "cashAccountType", "accountStatus", "bic", "linkedAccounts", "usageType", "details", "balances", "ownerName", "ownerAddress"})
    public Xs2aAccountDetails(String aspspAccountId, String resourceId, String iban, String bban, String pan, String maskedPan, String msisdn, Currency currency, String name, String displayName, String product, CashAccountType cashAccountType, AccountStatus accountStatus, String bic, String linkedAccounts, Xs2aUsageType usageType, String details, List<Xs2aBalance> balances, String ownerName, Xs2aAddress ownerAddress) {
        this.aspspAccountId = aspspAccountId;
        this.resourceId = resourceId;
        this.iban = iban;
        this.bban = bban;
        this.pan = pan;
        this.maskedPan = maskedPan;
        this.msisdn = msisdn;
        this.currency = currency;
        this.name = name;
        this.displayName = displayName;
        this.product = product;
        this.cashAccountType = cashAccountType;
        this.accountStatus = accountStatus;
        this.bic = bic;
        this.linkedAccounts = linkedAccounts;
        this.usageType = usageType;
        this.details = details;
        this.balances = balances;
        this.ownerName = ownerName;
        this.ownerAddress = ownerAddress;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBban() {
        return this.bban;
    }

    public String getPan() {
        return this.pan;
    }

    public String getMaskedPan() {
        return this.maskedPan;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProduct() {
        return this.product;
    }

    public CashAccountType getCashAccountType() {
        return this.cashAccountType;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public String getBic() {
        return this.bic;
    }

    public String getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public Xs2aUsageType getUsageType() {
        return this.usageType;
    }

    public String getDetails() {
        return this.details;
    }

    public List<Xs2aBalance> getBalances() {
        return this.balances;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Xs2aAddress getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xs2aAccountDetails)) {
            return false;
        }
        Xs2aAccountDetails other = (Xs2aAccountDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bban = this.getBban();
        String other$bban = other.getBban();
        if (this$bban == null ? other$bban != null : !this$bban.equals(other$bban)) {
            return false;
        }
        String this$pan = this.getPan();
        String other$pan = other.getPan();
        if (this$pan == null ? other$pan != null : !this$pan.equals(other$pan)) {
            return false;
        }
        String this$maskedPan = this.getMaskedPan();
        String other$maskedPan = other.getMaskedPan();
        if (this$maskedPan == null ? other$maskedPan != null : !this$maskedPan.equals(other$maskedPan)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        CashAccountType this$cashAccountType = this.getCashAccountType();
        CashAccountType other$cashAccountType = other.getCashAccountType();
        if (this$cashAccountType == null ? other$cashAccountType != null : !((Object)((Object)this$cashAccountType)).equals((Object)other$cashAccountType)) {
            return false;
        }
        AccountStatus this$accountStatus = this.getAccountStatus();
        AccountStatus other$accountStatus = other.getAccountStatus();
        if (this$accountStatus == null ? other$accountStatus != null : !((Object)((Object)this$accountStatus)).equals((Object)other$accountStatus)) {
            return false;
        }
        String this$bic = this.getBic();
        String other$bic = other.getBic();
        if (this$bic == null ? other$bic != null : !this$bic.equals(other$bic)) {
            return false;
        }
        String this$linkedAccounts = this.getLinkedAccounts();
        String other$linkedAccounts = other.getLinkedAccounts();
        if (this$linkedAccounts == null ? other$linkedAccounts != null : !this$linkedAccounts.equals(other$linkedAccounts)) {
            return false;
        }
        Xs2aUsageType this$usageType = this.getUsageType();
        Xs2aUsageType other$usageType = other.getUsageType();
        if (this$usageType == null ? other$usageType != null : !((Object)((Object)this$usageType)).equals((Object)other$usageType)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        List<Xs2aBalance> this$balances = this.getBalances();
        List<Xs2aBalance> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$ownerName = this.getOwnerName();
        String other$ownerName = other.getOwnerName();
        if (this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName)) {
            return false;
        }
        Xs2aAddress this$ownerAddress = this.getOwnerAddress();
        Xs2aAddress other$ownerAddress = other.getOwnerAddress();
        return !(this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Xs2aAccountDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bban = this.getBban();
        result = result * 59 + ($bban == null ? 43 : $bban.hashCode());
        String $pan = this.getPan();
        result = result * 59 + ($pan == null ? 43 : $pan.hashCode());
        String $maskedPan = this.getMaskedPan();
        result = result * 59 + ($maskedPan == null ? 43 : $maskedPan.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        CashAccountType $cashAccountType = this.getCashAccountType();
        result = result * 59 + ($cashAccountType == null ? 43 : ((Object)((Object)$cashAccountType)).hashCode());
        AccountStatus $accountStatus = this.getAccountStatus();
        result = result * 59 + ($accountStatus == null ? 43 : ((Object)((Object)$accountStatus)).hashCode());
        String $bic = this.getBic();
        result = result * 59 + ($bic == null ? 43 : $bic.hashCode());
        String $linkedAccounts = this.getLinkedAccounts();
        result = result * 59 + ($linkedAccounts == null ? 43 : $linkedAccounts.hashCode());
        Xs2aUsageType $usageType = this.getUsageType();
        result = result * 59 + ($usageType == null ? 43 : ((Object)((Object)$usageType)).hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        List<Xs2aBalance> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $ownerName = this.getOwnerName();
        result = result * 59 + ($ownerName == null ? 43 : $ownerName.hashCode());
        Xs2aAddress $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        return result;
    }

    public String toString() {
        return "Xs2aAccountDetails(aspspAccountId=" + this.getAspspAccountId() + ", resourceId=" + this.getResourceId() + ", iban=" + this.getIban() + ", bban=" + this.getBban() + ", pan=" + this.getPan() + ", maskedPan=" + this.getMaskedPan() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", product=" + this.getProduct() + ", cashAccountType=" + (Object)((Object)this.getCashAccountType()) + ", accountStatus=" + (Object)((Object)this.getAccountStatus()) + ", bic=" + this.getBic() + ", linkedAccounts=" + this.getLinkedAccounts() + ", usageType=" + (Object)((Object)this.getUsageType()) + ", details=" + this.getDetails() + ", balances=" + this.getBalances() + ", links=" + this.getLinks() + ", ownerName=" + this.getOwnerName() + ", ownerAddress=" + this.getOwnerAddress() + ")";
    }
}

