/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PisAuthorisationCancellationLinks
extends AbstractLinks {
    private RedirectLinkBuilder redirectLinkBuilder;
    private ScaRedirectFlow scaRedirectFlow;
    private RedirectIdService redirectIdService;

    public PisAuthorisationCancellationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, String paymentService, String paymentProduct, String paymentId, String authorisationId, ScaRedirectFlow scaRedirectFlow, String internalRequestId) {
        super(httpUrl);
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.scaRedirectFlow = scaRedirectFlow;
        this.redirectIdService = redirectIdService;
        this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        ScaApproach cancellationScaApproach = scaApproachResolver.getScaApproach(authorisationId);
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(cancellationScaApproach)) {
            this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        } else if (cancellationScaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId, internalRequestId);
        } else if (cancellationScaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth(new HrefType("scaOAuth"));
        }
    }

    private void addRedirectRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorizationId, String internalRequestId) {
        String redirectId = this.redirectIdService.generateRedirectId(authorizationId);
        String paymentCancellationOauthLink = this.scaRedirectFlow == ScaRedirectFlow.OAUTH ? this.redirectLinkBuilder.buildPaymentCancellationScaOauthRedirectLink(paymentId, redirectId, internalRequestId) : this.redirectLinkBuilder.buildPaymentCancellationScaRedirectLink(paymentId, redirectId, internalRequestId);
        this.setScaRedirectOAuthLink(this.scaRedirectFlow, paymentCancellationOauthLink);
        this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorizationId));
    }
}

