/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.authorisation;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorisationStatusValidator {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationStatusValidator.class);
    private final AspspProfileServiceWrapper aspspProfileService;

    @NotNull
    public ValidationResult validate(@NotNull ScaStatus scaStatus, @NotNull boolean confirmationCodeReceived) {
        if (scaStatus != ScaStatus.FAILED) {
            return ValidationResult.valid();
        }
        if (this.aspspProfileService.isAuthorisationConfirmationRequestMandated() && confirmationCodeReceived) {
            return ValidationResult.invalid(this.getErrorTypeForSCAInvalid(), MessageErrorCode.SCA_INVALID);
        }
        log.info("Authorisation has failed status");
        return ValidationResult.invalid(this.getErrorTypeForStatusInvalid(), MessageErrorCode.STATUS_INVALID);
    }

    @NotNull
    protected abstract ErrorType getErrorTypeForStatusInvalid();

    @NotNull
    protected abstract ErrorType getErrorTypeForSCAInvalid();

    @ConstructorProperties(value={"aspspProfileService"})
    public AuthorisationStatusValidator(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

