/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessMultipleAccountsValidator {
    public ValidationResult validate(AisConsent aisConsent, boolean withBalance) {
        if (withBalance && aisConsent.isConsentForDedicatedAccounts()) {
            AccountAccess access = aisConsent.getAccess();
            return this.validateAccountReferenceSize(access.getAccounts(), access.getBalances()) ? ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID) : ValidationResult.valid();
        }
        return ValidationResult.valid();
    }

    private boolean validateAccountReferenceSize(List<AccountReference> accounts, List<AccountReference> balances) {
        List filteredAccountReferences = accounts.stream().filter(AccountReference::isNotCardAccount).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(filteredAccountReferences) && CollectionUtils.isNotEmpty(balances) && filteredAccountReferences.size() > balances.size();
    }
}

