/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.EndpointAccessChecker;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class AisEndpointAccessCheckerService
extends EndpointAccessChecker {
    private final Xs2aAisConsentService aisConsentService;
    private final AspspProfileServiceWrapper aspspProfileService;

    public boolean isEndpointAccessible(String authorisationId, boolean confirmationCodeReceived) {
        boolean confirmationCodeCase = confirmationCodeReceived && this.aspspProfileService.isAuthorisationConfirmationRequestMandated();
        return this.aisConsentService.getAccountConsentAuthorizationById(authorisationId).map(a -> this.isAccessible(a.getChosenScaApproach(), a.getScaStatus(), confirmationCodeCase)).orElse(true);
    }

    @ConstructorProperties(value={"aisConsentService", "aspspProfileService"})
    public AisEndpointAccessCheckerService(Xs2aAisConsentService aisConsentService, AspspProfileServiceWrapper aspspProfileService) {
        this.aisConsentService = aisConsentService;
        this.aspspProfileService = aspspProfileService;
    }
}

