/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.CardAccountDetails;
import de.adorsys.psd2.model.CardAccountReport;
import de.adorsys.psd2.model.CardAccountsTransactionsResponse200;
import de.adorsys.psd2.model.CardTransaction;
import de.adorsys.psd2.model.ReadCardAccountBalanceResponse200;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.CardAccountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CardAccountModelMapperImpl
extends CardAccountModelMapper {
    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public CardAccountDetails mapToCardAccountDetails(Xs2aCardAccountDetails accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        CardAccountDetails cardAccountDetails = new CardAccountDetails();
        cardAccountDetails.setUsage(this.xs2aUsageTypeToUsageEnum(accountDetails.getUsageType()));
        cardAccountDetails.setStatus(this.accountStatusToAccountStatus(accountDetails.getAccountStatus()));
        cardAccountDetails.setResourceId(accountDetails.getResourceId());
        cardAccountDetails.setMaskedPan(accountDetails.getMaskedPan());
        cardAccountDetails.setOwnerName(accountDetails.getOwnerName());
        cardAccountDetails.setName(accountDetails.getName());
        cardAccountDetails.setDisplayName(accountDetails.getDisplayName());
        cardAccountDetails.setProduct(accountDetails.getProduct());
        cardAccountDetails.setDetails(accountDetails.getDetails());
        cardAccountDetails.setCreditLimit(this.amountModelMapper.mapToAmount(accountDetails.getCreditLimit()));
        cardAccountDetails.setBalances(this.mapToBalanceList(accountDetails.getBalances()));
        cardAccountDetails.setLinks(this.hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()));
        cardAccountDetails.setCurrency(this.mapToAccountDetailsCurrency(accountDetails.getCurrency()));
        return cardAccountDetails;
    }

    @Override
    public Balance mapToBalance(Xs2aBalance balance) {
        if (balance == null) {
            return null;
        }
        Balance balance1 = new Balance();
        balance1.setBalanceAmount(this.amountModelMapper.mapToAmount(balance.getBalanceAmount()));
        balance1.setCreditLimitIncluded(balance.getCreditLimitIncluded());
        balance1.setReferenceDate(balance.getReferenceDate());
        balance1.setLastCommittedTransaction(balance.getLastCommittedTransaction());
        balance1.setLastChangeDateTime(this.mapToOffsetDateTime(balance.getLastChangeDateTime()));
        balance1.setBalanceType(this.mapToBalanceType(balance.getBalanceType()));
        return balance1;
    }

    @Override
    public ReadCardAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        if (balancesReport == null) {
            return null;
        }
        ReadCardAccountBalanceResponse200 readCardAccountBalanceResponse200 = new ReadCardAccountBalanceResponse200();
        readCardAccountBalanceResponse200.setCardAccount(this.accountReferenceToAccountReference(balancesReport.getXs2aAccountReference()));
        readCardAccountBalanceResponse200.setBalances(this.mapToBalanceList(balancesReport.getBalances()));
        return readCardAccountBalanceResponse200;
    }

    @Override
    public CardAccountReport mapToCardAccountReport(Xs2aCardAccountReport accountReport) {
        if (accountReport == null) {
            return null;
        }
        CardAccountReport cardAccountReport = new CardAccountReport();
        cardAccountReport.setBooked(this.mapToCardTransactionList(accountReport.getBooked()));
        cardAccountReport.setPending(this.mapToCardTransactionList(accountReport.getPending()));
        cardAccountReport.setLinks(this.hrefLinkMapper.mapToLinksMap(accountReport.getLinks()));
        return cardAccountReport;
    }

    @Override
    public CardAccountsTransactionsResponse200 mapToTransactionsResponse200Json(Xs2aCardTransactionsReport cardTransactionsReport) {
        if (cardTransactionsReport == null) {
            return null;
        }
        CardAccountsTransactionsResponse200 cardAccountsTransactionsResponse200 = new CardAccountsTransactionsResponse200();
        cardAccountsTransactionsResponse200.setCardAccount(this.accountReferenceToAccountReference(cardTransactionsReport.getAccountReference()));
        cardAccountsTransactionsResponse200.setCardTransactions(this.mapToCardAccountReport(cardTransactionsReport.getCardAccountReport()));
        cardAccountsTransactionsResponse200.setBalances(this.mapToBalanceList(cardTransactionsReport.getBalances()));
        cardAccountsTransactionsResponse200.setLinks(this.hrefLinkMapper.mapToLinksMap(cardTransactionsReport.getLinks()));
        return cardAccountsTransactionsResponse200;
    }

    @Override
    public CardTransaction mapToCardTransaction(de.adorsys.psd2.xs2a.domain.CardTransaction transactions) {
        if (transactions == null) {
            return null;
        }
        CardTransaction cardTransaction = new CardTransaction();
        cardTransaction.setCardTransactionId(transactions.getCardTransactionId());
        cardTransaction.setTerminalId(transactions.getTerminalId());
        cardTransaction.setTransactionDate(transactions.getTransactionDate());
        cardTransaction.setAcceptorTransactionDateTime(transactions.getAcceptorTransactionDateTime());
        cardTransaction.setBookingDate(transactions.getBookingDate());
        cardTransaction.setTransactionAmount(this.amountModelMapper.mapToAmount(transactions.getTransactionAmount()));
        cardTransaction.setOriginalAmount(this.amountModelMapper.mapToAmount(transactions.getOriginalAmount()));
        cardTransaction.setMarkupFee(this.amountModelMapper.mapToAmount(transactions.getMarkupFee()));
        cardTransaction.setMarkupFeePercentage(transactions.getMarkupFeePercentage());
        cardTransaction.setCardAcceptorId(transactions.getCardAcceptorId());
        cardTransaction.setCardAcceptorAddress(this.xs2aAddressMapper.mapToAddress(transactions.getCardAcceptorAddress()));
        cardTransaction.setCardAcceptorPhone(transactions.getCardAcceptorPhone());
        cardTransaction.setMerchantCategoryCode(transactions.getMerchantCategoryCode());
        cardTransaction.setMaskedPAN(transactions.getMaskedPAN());
        cardTransaction.setTransactionDetails(transactions.getTransactionDetails());
        cardTransaction.setInvoiced(transactions.getInvoiced());
        cardTransaction.setProprietaryBankTransactionCode(transactions.getProprietaryBankTransactionCode());
        cardTransaction.setCurrencyExchange(this.mapToReportExchanges(transactions.getCurrencyExchange()));
        return cardTransaction;
    }

    @Override
    protected ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate xs2aExchangeRate) {
        if (xs2aExchangeRate == null) {
            return null;
        }
        ReportExchangeRate reportExchangeRate = new ReportExchangeRate();
        reportExchangeRate.setSourceCurrency(xs2aExchangeRate.getSourceCurrency());
        reportExchangeRate.setExchangeRate(xs2aExchangeRate.getExchangeRate());
        reportExchangeRate.setUnitCurrency(xs2aExchangeRate.getUnitCurrency());
        reportExchangeRate.setTargetCurrency(xs2aExchangeRate.getTargetCurrency());
        reportExchangeRate.setQuotationDate(xs2aExchangeRate.getQuotationDate());
        reportExchangeRate.setContractIdentification(xs2aExchangeRate.getContractIdentification());
        return reportExchangeRate;
    }

    protected CardAccountDetails.UsageEnum xs2aUsageTypeToUsageEnum(Xs2aUsageType xs2aUsageType) {
        CardAccountDetails.UsageEnum usageEnum;
        if (xs2aUsageType == null) {
            return null;
        }
        switch (xs2aUsageType) {
            case PRIV: {
                usageEnum = CardAccountDetails.UsageEnum.PRIV;
                break;
            }
            case ORGA: {
                usageEnum = CardAccountDetails.UsageEnum.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)xs2aUsageType));
            }
        }
        return usageEnum;
    }

    protected AccountStatus accountStatusToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        AccountStatus accountStatus1;
        if (accountStatus == null) {
            return null;
        }
        switch (accountStatus) {
            case ENABLED: {
                accountStatus1 = AccountStatus.ENABLED;
                break;
            }
            case DELETED: {
                accountStatus1 = AccountStatus.DELETED;
                break;
            }
            case BLOCKED: {
                accountStatus1 = AccountStatus.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)accountStatus));
            }
        }
        return accountStatus1;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        accountReference1.setCurrency(this.mapToAccountDetailsCurrency(accountReference.getCurrency()));
        return accountReference1;
    }
}

