/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import java.beans.ConstructorProperties;
import java.util.Currency;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AmountModelMapper {
    private final ValueValidatorService valueValidatorService;

    public Xs2aAmount mapToXs2aAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Xs2aAmount amountTarget = new Xs2aAmount();
            amountTarget.setAmount(a.getAmount());
            amountTarget.setCurrency(this.getCurrencyByCode(a.getCurrency()));
            this.valueValidatorService.validate(amountTarget, new Class[0]);
            return amountTarget;
        }).orElse(null);
    }

    public Amount mapToAmount(Xs2aAmount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Amount amountTarget = new Amount();
            amountTarget.setAmount(a.getAmount());
            if (a.getCurrency() != null) {
                amountTarget.setCurrency(a.getCurrency().getCurrencyCode());
            }
            return amountTarget;
        }).orElse(null);
    }

    private Currency getCurrencyByCode(String code) {
        return StringUtils.isNotBlank((CharSequence)code) ? Currency.getInstance(code) : null;
    }

    @ConstructorProperties(value={"valueValidatorService"})
    public AmountModelMapper(ValueValidatorService valueValidatorService) {
        this.valueValidatorService = valueValidatorService;
    }
}

