/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.authorisation.AisAuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreateAisConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aAisConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final AisConsentServiceEncrypted aisConsentService;
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final ScaApproachResolver scaApproachResolver;
    private final RequestProviderService requestProviderService;
    private final LoggingContextService loggingContextService;

    public Optional<Xs2aCreateAisConsentResponse> createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        CmsResponse response;
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CmsConsent cmsConsent = this.aisConsentMapper.mapToCmsConsent(request, psuData, tppInfo, allowedFrequencyPerDay);
        try {
            response = this.consentService.createConsent(cmsConsent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent cannot be created, checksum verification failed");
            return Optional.empty();
        }
        if (response.hasError()) {
            log.info("Consent cannot be created, because can't save to cms DB");
            return Optional.empty();
        }
        CmsCreateConsentResponse createConsentResponse = (CmsCreateConsentResponse)response.getPayload();
        return Optional.of(new Xs2aCreateAisConsentResponse(createConsentResponse.getConsentId(), this.aisConsentMapper.mapToAisConsent(createConsentResponse.getCmsConsent()), createConsentResponse.getCmsConsent().getTppInformation().getTppNotificationSupportedModes()));
    }

    public Optional<AisConsent> getAccountConsentById(String consentId) {
        CmsResponse consentById = this.consentService.getConsentById(consentId);
        if (consentById.hasError()) {
            log.info("Get consent by id failed due to CMS problems");
            return Optional.empty();
        }
        return Optional.ofNullable(this.aisConsentMapper.mapToAisConsent((CmsConsent)consentById.getPayload()));
    }

    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        CmsResponse response = this.consentService.findAndTerminateOldConsentsByNewConsentId(newConsentId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        CmsResponse statusUpdated;
        try {
            statusUpdated = this.consentService.updateConsentStatusById(consentId, consentStatus);
        }
        catch (WrongChecksumException e) {
            log.info("updateConsentStatus cannot be executed, checksum verification failed");
            return;
        }
        if (statusUpdated.isSuccessful() && BooleanUtils.isTrue((Boolean)((Boolean)statusUpdated.getPayload()))) {
            this.loggingContextService.storeConsentStatus(consentStatus);
        }
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus, String requestUri, boolean updateUsage, String resourceId, String transactionId) {
        try {
            this.aisConsentService.checkConsentAndSaveActionLog(new AisConsentActionRequest(tppId, consentId, actionStatus, requestUri, updateUsage, resourceId, transactionId));
        }
        catch (WrongChecksumException e) {
            log.info("consentActionLog cannot be executed, checksum verification failed");
        }
    }

    public Optional<CreateAuthorisationResponse> createAisConsentAuthorization(String consentId, ScaStatus scaStatus, PsuIdData psuData) {
        String tppRedirectURI = this.requestProviderService.getTppRedirectURI();
        String tppNOKRedirectURI = this.requestProviderService.getTppNokRedirectURI();
        CreateAuthorisationRequest request = this.aisConsentAuthorisationMapper.mapToAuthorisationRequest(scaStatus, psuData, this.scaApproachResolver.resolveScaApproach(), tppRedirectURI, tppNOKRedirectURI);
        CmsResponse authorisationResponse = this.authorisationServiceEncrypted.createAuthorisation((AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId), request);
        if (authorisationResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable(authorisationResponse.getPayload());
    }

    public Optional<Authorisation> getAccountConsentAuthorizationById(String authorizationId) {
        CmsResponse authorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorizationId);
        if (authorisationResponse.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable(authorisationResponse.getPayload());
    }

    public void updateConsentAuthorization(UpdateConsentPsuDataReq updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            String authorizationId = req.getAuthorizationId();
            UpdateAuthorisationRequest request = this.aisConsentAuthorisationMapper.mapToAuthorisationRequest((UpdateConsentPsuDataReq)req);
            this.authorisationServiceEncrypted.updateAuthorisation(authorizationId, request);
        });
    }

    public void updateConsentAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        this.authorisationServiceEncrypted.updateAuthorisationStatus(authorisationId, scaStatus);
    }

    public CmsResponse<AisConsent> updateAspspAccountAccess(String consentId, AisAccountAccessInfo aisAccountAccessInfo) {
        CmsResponse response;
        CmsResponse.CmsResponseBuilder builder = CmsResponse.builder();
        try {
            response = this.aisConsentService.updateAspspAccountAccess(consentId, aisAccountAccessInfo);
        }
        catch (WrongChecksumException e) {
            return builder.error(CmsError.CHECKSUM_ERROR).build();
        }
        if (response.hasError()) {
            return builder.error(response.getError()).build();
        }
        return builder.payload((Object)this.aisConsentMapper.mapToAisConsent((CmsConsent)response.getPayload())).build();
    }

    public Optional<List<String>> getAuthorisationSubResources(String consentId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationsByParentId((AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId));
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable(response.getPayload());
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaStatus(authorisationId, (AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId));
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable(response.getPayload());
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        CmsResponse response = this.authorisationServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<AuthenticationObject> methods) {
        CmsResponse response = this.authorisationServiceEncrypted.saveAuthenticationMethods(authorisationId, this.xs2AAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        this.authorisationServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
    }

    public void updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        try {
            this.consentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
        catch (WrongChecksumException e) {
            log.info("updateMultilevelScaRequired cannot be executed, checksum verification failed");
        }
    }

    public Optional<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaApproach(authorisationId);
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable(response.getPayload());
    }

    @ConstructorProperties(value={"consentService", "aisConsentService", "authorisationServiceEncrypted", "aisConsentMapper", "aisConsentAuthorisationMapper", "xs2AAuthenticationObjectToCmsScaMethodMapper", "frequencyPerDateCalculationService", "scaApproachResolver", "requestProviderService", "loggingContextService"})
    public Xs2aAisConsentService(ConsentServiceEncrypted consentService, AisConsentServiceEncrypted aisConsentService, AuthorisationServiceEncrypted authorisationServiceEncrypted, Xs2aAisConsentMapper aisConsentMapper, Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, ScaApproachResolver scaApproachResolver, RequestProviderService requestProviderService, LoggingContextService loggingContextService) {
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.aisConsentMapper = aisConsentMapper;
        this.aisConsentAuthorisationMapper = aisConsentAuthorisationMapper;
        this.xs2AAuthenticationObjectToCmsScaMethodMapper = xs2AAuthenticationObjectToCmsScaMethodMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.scaApproachResolver = scaApproachResolver;
        this.requestProviderService = requestProviderService;
        this.loggingContextService = loggingContextService;
    }
}

