/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component.logger;

import de.adorsys.psd2.xs2a.component.logger.TppLogType;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TppLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"access-log");

    private TppLogger() {
    }

    public static TppRequestLogBuilder logRequest(HttpServletRequest request) {
        return new TppRequestLogBuilder(request);
    }

    public static TppResponseLogBuilder logResponse(HttpServletResponse response) {
        return new TppResponseLogBuilder(response);
    }

    public static abstract class TppLogBuilder<T extends TppLogBuilder<T>> {
        private Map<String, String> logParams = new LinkedHashMap<String, String>();
        private TppLogType tppLogType;

        TppLogBuilder(TppLogType tppLogType) {
            this.tppLogType = tppLogType;
        }

        public T withParam(String paramName, String paramValue) {
            if (StringUtils.isNotBlank((CharSequence)paramValue)) {
                this.putLogParameter(paramName, paramValue);
            }
            return this.getThis();
        }

        public void perform() {
            String logMessageParams = this.logParams.entrySet().stream().map(e -> (String)e.getKey() + ": [" + (String)e.getValue() + "]").collect(Collectors.joining(", "));
            log.info(this.tppLogType.name() + " - " + logMessageParams);
        }

        void putLogParameter(String parameterName, String parameterValue) {
            this.logParams.put(parameterName, parameterValue);
        }

        protected abstract T getThis();
    }
}

