/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.IbanValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type.SinglePaymentTypeValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeriodicPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    @Autowired
    public PeriodicPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMappe, PaymentMapper paymentMapper, AmountValidator amountValidator, IbanValidator ibanValidator) {
        super(errorBuildingService, xs2aObjectMappe, paymentMapper, amountValidator, ibanValidator);
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.PERIODIC;
    }

    @Override
    public MessageError validate(Object body, MessageError messageError, PaymentValidationConfig validationConfig) {
        try {
            this.doPeriodicValidation(this.paymentMapper.mapToPeriodicPayment(body), messageError, validationConfig);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unrecognized field")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, (Object[])new Object[]{this.extractErrorField(e.getMessage())}));
            }
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR));
        }
        return messageError;
    }

    void doPeriodicValidation(PeriodicPayment periodicPayment, MessageError messageError, PaymentValidationConfig validationConfig) {
        super.doSingleValidation(periodicPayment, messageError, validationConfig);
        if (periodicPayment.getStartDate() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"startDate"}));
        } else {
            this.validateStartDate(periodicPayment.getStartDate(), messageError);
        }
        if (periodicPayment.getExecutionRule() != null) {
            this.checkFieldForMaxLength(periodicPayment.getExecutionRule().getValue(), "executionRule", validationConfig.getExecutionRule(), messageError);
        }
        if (periodicPayment.getFrequency() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"frequency"}));
        }
        if (this.areDatesInvalidInPeriodicPayment(periodicPayment)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PERIOD_INVALID_WRONG_ORDER));
        }
        if (validationConfig.getDayOfExecution().isRequired() && periodicPayment.getDayOfExecution() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"dayOfExecution"}));
        }
    }

    private void validateStartDate(LocalDate startDate, MessageError messageError) {
        if (startDate.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_DATE_IN_THE_PAST, (Object[])new Object[]{"startDate"}));
        }
    }

    private boolean areDatesInvalidInPeriodicPayment(PeriodicPayment periodicPayment) {
        LocalDate paymentStartDate = periodicPayment.getStartDate();
        if (paymentStartDate == null || paymentStartDate.isBefore(LocalDate.now())) {
            return false;
        }
        LocalDate paymentEndDate = periodicPayment.getEndDate();
        return this.isDateInThePast(paymentStartDate) || Optional.ofNullable(paymentEndDate).map(dt -> dt.isBefore(paymentStartDate)).orElse(false) != false;
    }
}

