/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.ObjectValidator;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class StringMaxLengthValidator
implements ObjectValidator<MaxLengthRequirement> {
    private final ErrorBuildingService errorBuildingService;

    @Override
    public void validate(@NotNull MaxLengthRequirement object, @NotNull MessageError messageError) {
        if (object.getField() != null && object.getField().length() > object.getMaxLength()) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_OVERSIZE_FIELD, (Object[])new Object[]{object.getFieldName(), object.getMaxLength()}));
        }
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public StringMaxLengthValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }

    public static final class MaxLengthRequirement {
        private final String field;
        private final String fieldName;
        private final int maxLength;

        @ConstructorProperties(value={"field", "fieldName", "maxLength"})
        public MaxLengthRequirement(String field, String fieldName, int maxLength) {
            this.field = field;
            this.fieldName = fieldName;
            this.maxLength = maxLength;
        }

        public String getField() {
            return this.field;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaxLengthRequirement)) {
                return false;
            }
            MaxLengthRequirement other = (MaxLengthRequirement)o;
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            return this.getMaxLength() == other.getMaxLength();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            result = result * 59 + this.getMaxLength();
            return result;
        }

        public String toString() {
            return "StringMaxLengthValidator.MaxLengthRequirement(field=" + this.getField() + ", fieldName=" + this.getFieldName() + ", maxLength=" + this.getMaxLength() + ")";
        }
    }
}

