/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountDetailsMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetAccountListValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountListConsentObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountListService {
    private static final Logger log = LoggerFactory.getLogger(AccountListService.class);
    private final AccountSpi accountSpi;
    private final SpiToXs2aAccountDetailsMapper accountDetailsMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final GetAccountListValidator getAccountListValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aAccountListHolder> getAccountList(String consentId, boolean withBalance, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_LIST_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!aisConsentOptional.isPresent()) {
            log.info("Consent-ID [{}]. Get account list failed. Account consent not found by id", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForGetAccountListConsent(withBalance, requestUri, aisConsent);
        if (validationResult.isNotValid()) {
            log.info("Consent-ID [{}], WithBalance [{}], RequestUri [{}]. Get account list - validation failed: {}", new Object[]{consentId, withBalance, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<List<SpiAccountDetails>> spiResponse = this.getSpiResponse(aisConsent, consentId, withBalance);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("Consent-ID: [{}]. Get account list failed: couldn't get accounts. Error msg: [{}]", (Object)consentId, (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        List<Xs2aAccountDetails> accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetailsList((List)spiResponse.getPayload());
        CmsResponse<AisConsent> aisConsentUpdated = this.accountReferenceUpdater.updateAccountReferences(consentId, aisConsent, accountDetails);
        if (aisConsentUpdated.hasError()) {
            log.info("Consent-ID: [{}]. Get account list failed: couldn't update account consent access.", (Object)consentId);
            if (CmsError.CHECKSUM_ERROR == aisConsentUpdated.getError()) {
                return ResponseObject.builder().fail(ErrorType.AIS_500, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_VALIDATION_FAILED)).build();
            }
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getXs2aAccountListHolderResponseObject(consentId, withBalance, requestUri, (AisConsent)aisConsentUpdated.getPayload(), accountDetails);
    }

    private ValidationResult getValidationResultForGetAccountListConsent(boolean withBalance, String requestUri, AisConsent aisConsent) {
        GetAccountListConsentObject validatorObject = new GetAccountListConsentObject(aisConsent, withBalance, requestUri);
        return this.getAccountListValidator.validate(validatorObject);
    }

    private SpiResponse<List<SpiAccountDetails>> getSpiResponse(AisConsent aisConsent, String consentId, boolean withBalance) {
        return this.accountSpi.requestAccountList(this.accountHelperService.getSpiContextData(), withBalance, this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    @NotNull
    private ResponseObject<Xs2aAccountListHolder> getXs2aAccountListHolderResponseObject(String consentId, boolean withBalance, String requestUri, AisConsent aisConsent, List<Xs2aAccountDetails> accountDetails) {
        Xs2aAccountListHolder xs2aAccountListHolder = new Xs2aAccountListHolder(accountDetails, aisConsent);
        ResponseObject<Xs2aAccountListHolder> response = ResponseObject.builder().body(xs2aAccountListHolder).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(withBalance, TypeAccess.ACCOUNT, response), requestUri, this.accountHelperService.needsToUpdateUsage(aisConsent), null, null);
        return response;
    }

    @ConstructorProperties(value={"accountSpi", "accountDetailsMapper", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "accountReferenceUpdater", "spiErrorMapper", "getAccountListValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService"})
    public AccountListService(AccountSpi accountSpi, SpiToXs2aAccountDetailsMapper accountDetailsMapper, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, GetAccountListValidator getAccountListValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService) {
        this.accountSpi = accountSpi;
        this.accountDetailsMapper = accountDetailsMapper;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.getAccountListValidator = getAccountListValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
    }
}

