/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class AccountOwnerInformationService {
    private static final AccountAccessType ALL_ACCOUNTS_WITH_OWNER_NAME = AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME;
    private static final AccountAccessType ALL_ACCOUNTS = AccountAccessType.ALL_ACCOUNTS;
    private final AspspProfileServiceWrapper aspspProfileService;

    public CreateConsentReq checkSupportedAccountOwnerInformation(CreateConsentReq request) {
        if (!this.aspspProfileService.isAccountOwnerInformationSupported()) {
            return this.cleanAccountOwnerInformation(request);
        }
        return request;
    }

    private CreateConsentReq cleanAccountOwnerInformation(CreateConsentReq request) {
        AccountAccess access = request.getAccess();
        if (request.getAvailableAccounts() == ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAvailableAccounts(ALL_ACCOUNTS);
        }
        if (request.getAvailableAccountsWithBalance() == ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAvailableAccountsWithBalance(ALL_ACCOUNTS);
        }
        if (request.getAllPsd2() == ALL_ACCOUNTS_WITH_OWNER_NAME) {
            request.setAllPsd2(ALL_ACCOUNTS);
        }
        if (this.isConsentWithAdditionalInformationAccess(access)) {
            AccountAccess accessWithoutOwnerName = new AccountAccess(access.getAccounts(), access.getBalances(), access.getTransactions(), null);
            request.setAccess(accessWithoutOwnerName);
        }
        return request;
    }

    private boolean isConsentWithAdditionalInformationAccess(AccountAccess access) {
        return Optional.ofNullable(access.getAdditionalInformationAccess()).map(AdditionalInformationAccess::getOwnerName).isPresent();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AccountOwnerInformationService(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

