/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.exception;

import de.adorsys.psd2.aspsp.profile.exception.AspspProfileRestException;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.exception.CertificateException;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.exception.WrongPaymentTypeException;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import java.beans.ConstructorProperties;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice(basePackages={"de.adorsys.psd2.xs2a.web.controller"})
public class GlobalExceptionHandlerController {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerController.class);
    private final ResponseErrorMapper responseErrorMapper;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity validationException(ValidationException ex, HandlerMethod handlerMethod) {
        log.warn("Validation exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    public ResponseEntity servletRequestBindingException(ServletRequestBindingException ex, HandlerMethod handlerMethod) {
        log.warn("Validation exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity illegalArgumentException(IllegalArgumentException ex, HandlerMethod handlerMethod) {
        log.warn("Illegal argument exception handled in: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity httpMessageException(HttpMessageNotReadableException ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception of HttpMessageNotReadableException class handled in Controller: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity mediaTypeNotSupportedException(HttpMediaTypeNotAcceptableException ex, HandlerMethod handlerMethod) {
        log.warn("Media type unsupported exception: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.UNSUPPORTED_MEDIA_TYPE));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity exception(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity restException(RestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(ex.getMessageErrorCode(), ex.getMessage()));
    }

    @ExceptionHandler(value={AspspProfileRestException.class})
    public ResponseEntity aspspProfileRestException(AspspProfileRestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={ResourceAccessException.class})
    public ResponseEntity resourceAccessException(ResourceAccessException ex, HandlerMethod handlerMethod) {
        log.warn("ResourceAccessException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateServiceUnavailableErrorResponse(ex.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity requestBodyValidationException(MethodArgumentNotValidException ex, HandlerMethod handlerMethod) {
        log.warn("RequestBodyValidationException handled in controller: {}, message: {} ", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={CertificateException.class})
    public ResponseEntity getTppIdException(CertificateException ex, HandlerMethod handlerMethod) {
        log.warn("Can't find tpp id in SecurityContextHolder in: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.CERTIFICATE_INVALID));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity methodArgumentTypeMismatchException(MethodArgumentTypeMismatchException ex, HandlerMethod handlerMethod) {
        log.warn("MethodArgumentTypeMismatchException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return this.responseErrorMapper.generateErrorResponse(this.createMessageError(MessageErrorCode.FORMAT_ERROR));
    }

    @ExceptionHandler(value={WrongPaymentTypeException.class})
    public ResponseEntity wrongPaymentTypeException(WrongPaymentTypeException ex, HandlerMethod handlerMethod) {
        log.warn("WrongPaymentTypeException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        MessageError messageError = new MessageError(ErrorType.PIS_400, new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_WRONG_PAYMENT_TYPE, (Object[])new Object[]{ex.getPaymentType()})});
        return this.responseErrorMapper.generateErrorResponse(messageError);
    }

    private MessageError createMessageError(MessageErrorCode messageErrorCode) {
        return new MessageError(this.getErrorType(messageErrorCode.getCode()), new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)messageErrorCode)});
    }

    private MessageError createMessageError(MessageErrorCode messageErrorCode, String message) {
        return new MessageError(this.getErrorType(messageErrorCode.getCode()), new TppMessageInformation[]{TppMessageInformation.buildWithCustomError((MessageErrorCode)messageErrorCode, (String)message)});
    }

    private ErrorType getErrorType(int code) {
        return this.errorTypeMapper.mapToErrorType(this.serviceTypeDiscoveryService.getServiceType(), code);
    }

    @ConstructorProperties(value={"responseErrorMapper", "serviceTypeDiscoveryService", "errorTypeMapper"})
    public GlobalExceptionHandlerController(ResponseErrorMapper responseErrorMapper, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper) {
        this.responseErrorMapper = responseErrorMapper;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
    }
}

