/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.validator.signature.DigestVerifier;
import de.adorsys.psd2.validator.signature.SignatureVerifier;
import de.adorsys.psd2.validator.signature.impl.DigestVerifierImpl;
import de.adorsys.psd2.validator.signature.impl.SignatureVerifierImpl;
import de.adorsys.psd2.xs2a.component.PaymentTypeEnumConverter;
import de.adorsys.psd2.xs2a.component.logger.request.RequestResponseLogger;
import de.adorsys.psd2.xs2a.config.CorsConfigurationProperties;
import de.adorsys.psd2.xs2a.config.Xs2aEndpointPathConstant;
import de.adorsys.psd2.xs2a.config.converter.MappingJackson2TextMessageConverter;
import de.adorsys.psd2.xs2a.domain.InternalRequestIdHolder;
import de.adorsys.psd2.xs2a.domain.RedirectIdHolder;
import de.adorsys.psd2.xs2a.domain.ScaApproachHolder;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceTypeToErrorTypeMapper;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import de.adorsys.psd2.xs2a.web.advice.Xs2aRestExceptionHandler;
import de.adorsys.psd2.xs2a.web.interceptor.logging.AccountLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.ConsentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.FundsConfirmationLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.PaymentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.RequestResponseLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.SigningBasketLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.tpp.TppStopListInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.validator.PaymentParametersValidationInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.validator.RequestValidationInterceptor;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class WebConfig
implements WebMvcConfigurer {
    @Qualifier(value="xs2aCorsConfigProperties")
    private final CorsConfigurationProperties corsConfigurationProperties;
    private final TppService tppService;
    private final TppStopListService tppStopListService;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ServiceTypeToErrorTypeMapper errorTypeMapper;
    private final ErrorMapperContainer errorMapperContainer;
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final RequestValidationInterceptor requestValidationInterceptor;
    private final RedirectIdService redirectIdService;
    private final RequestResponseLogger requestResponseLogger;
    private final LoggingContextService loggingContextService;
    private final PathParameterExtractor pathParameterExtractor;
    private final Xs2aRestExceptionHandler xs2aRestExceptionHandler;
    private final PaymentParametersValidationInterceptor paymentParametersValidationInterceptor;

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
        resolvers.add(0, (HandlerExceptionResolver)this.xs2aRestExceptionHandler);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseSuffixPatternMatch(Boolean.valueOf(false));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AccountLoggingInterceptor(this.tppService, this.loggingContextService, this.pathParameterExtractor)).addPathPatterns(new String[]{"/v1/accounts/**", "/v1/card-accounts/**"});
        registry.addInterceptor((HandlerInterceptor)new ConsentLoggingInterceptor(this.tppService, this.redirectIdService, this.loggingContextService, this.pathParameterExtractor)).addPathPatterns(new String[]{"/v1/consents/**"});
        registry.addInterceptor((HandlerInterceptor)new FundsConfirmationLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/funds-confirmations/**"});
        registry.addInterceptor((HandlerInterceptor)new PaymentLoggingInterceptor(this.tppService, this.redirectIdService, this.loggingContextService, this.pathParameterExtractor)).addPathPatterns(new String[]{"/v1/payments/**", "/v1/bulk-payments/**", "/v1/periodic-payments/**"});
        registry.addInterceptor((HandlerInterceptor)new SigningBasketLoggingInterceptor(this.tppService, this.redirectIdService, this.pathParameterExtractor)).addPathPatterns(new String[]{"/v1/signing-baskets/**"});
        registry.addInterceptor((HandlerInterceptor)new RequestResponseLoggingInterceptor(this.requestResponseLogger)).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
        registry.addInterceptor((HandlerInterceptor)new TppStopListInterceptor(this.errorMapperContainer, this.tppService, this.tppStopListService, this.serviceTypeDiscoveryService, this.errorTypeMapper, this.xs2aObjectMapper)).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
        registry.addInterceptor((HandlerInterceptor)this.paymentParametersValidationInterceptor).addPathPatterns(new String[]{"/v1/**"});
        registry.addInterceptor((HandlerInterceptor)this.requestValidationInterceptor).addPathPatterns(Xs2aEndpointPathConstant.getAllXs2aEndpointPaths());
    }

    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v1/**").allowCredentials(this.corsConfigurationProperties.getAllowCredentials().booleanValue()).allowedOrigins(this.getTargetParameters(this.corsConfigurationProperties.getAllowedOrigins())).allowedHeaders(this.getTargetParameters(this.corsConfigurationProperties.getAllowedHeaders())).allowedMethods(this.getTargetParameters(this.corsConfigurationProperties.getAllowedMethods())).maxAge(this.corsConfigurationProperties.getMaxAge());
    }

    private String[] getTargetParameters(List<String> targetParameters) {
        return targetParameters.toArray(new String[0]);
    }

    @Bean
    @RequestScope
    public TppInfoHolder getTppInfoHolder() {
        return new TppInfoHolder();
    }

    @Bean
    @RequestScope
    public ScaApproachHolder getScaApproachHolder() {
        return new ScaApproachHolder();
    }

    @Bean
    @RequestScope
    public RedirectIdHolder getRedirectIdHolder() {
        return new RedirectIdHolder();
    }

    @Bean
    @RequestScope
    public InternalRequestIdHolder getInternalRequestIdHolder() {
        return new InternalRequestIdHolder();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new PaymentTypeEnumConverter());
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2TextMessageConverter((ObjectMapper)this.xs2aObjectMapper));
    }

    @Bean
    public DigestVerifier digestVerifier() {
        return new DigestVerifierImpl();
    }

    @Bean
    public SignatureVerifier signatureVerifier() {
        return new SignatureVerifierImpl();
    }

    @ConstructorProperties(value={"corsConfigurationProperties", "tppService", "tppStopListService", "serviceTypeDiscoveryService", "errorTypeMapper", "errorMapperContainer", "xs2aObjectMapper", "requestValidationInterceptor", "redirectIdService", "requestResponseLogger", "loggingContextService", "pathParameterExtractor", "xs2aRestExceptionHandler", "paymentParametersValidationInterceptor"})
    public WebConfig(CorsConfigurationProperties corsConfigurationProperties, TppService tppService, TppStopListService tppStopListService, ServiceTypeDiscoveryService serviceTypeDiscoveryService, ServiceTypeToErrorTypeMapper errorTypeMapper, ErrorMapperContainer errorMapperContainer, Xs2aObjectMapper xs2aObjectMapper, RequestValidationInterceptor requestValidationInterceptor, RedirectIdService redirectIdService, RequestResponseLogger requestResponseLogger, LoggingContextService loggingContextService, PathParameterExtractor pathParameterExtractor, Xs2aRestExceptionHandler xs2aRestExceptionHandler, PaymentParametersValidationInterceptor paymentParametersValidationInterceptor) {
        this.corsConfigurationProperties = corsConfigurationProperties;
        this.tppService = tppService;
        this.tppStopListService = tppStopListService;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorTypeMapper = errorTypeMapper;
        this.errorMapperContainer = errorMapperContainer;
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.requestValidationInterceptor = requestValidationInterceptor;
        this.redirectIdService = redirectIdService;
        this.requestResponseLogger = requestResponseLogger;
        this.loggingContextService = loggingContextService;
        this.pathParameterExtractor = pathParameterExtractor;
        this.xs2aRestExceptionHandler = xs2aRestExceptionHandler;
        this.paymentParametersValidationInterceptor = paymentParametersValidationInterceptor;
    }
}

