/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.validator.payment.config.ValidationObject;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import java.util.Collection;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractBodyValidatorImpl
implements BodyValidator {
    protected ErrorBuildingService errorBuildingService;
    protected Xs2aObjectMapper xs2aObjectMapper;

    protected AbstractBodyValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper) {
        this.errorBuildingService = errorBuildingService;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }

    protected MessageError validateBodyFields(HttpServletRequest request, MessageError messageError) {
        return messageError;
    }

    protected MessageError validateRawData(HttpServletRequest request, MessageError messageError) {
        return messageError;
    }

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        MessageError result = this.validateRawData(request, messageError);
        if (CollectionUtils.isEmpty((Collection)result.getTppMessages())) {
            result = this.validateBodyFields(request, result);
        }
        return result;
    }

    protected void checkFieldForMaxLength(String fieldToCheck, String fieldName, ValidationObject validationObject, MessageError messageError) {
        if (validationObject.isNone() && Objects.nonNull(fieldToCheck)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, (Object[])new Object[]{fieldName}));
        } else if (validationObject.isRequired()) {
            if (StringUtils.isBlank((CharSequence)fieldToCheck)) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EMPTY_FIELD, (Object[])new Object[]{fieldName}));
            } else {
                this.checkFieldForMaxLength(fieldToCheck, fieldName, validationObject.getMaxLength(), messageError);
            }
        } else if (validationObject.isOptional() && StringUtils.isNotBlank((CharSequence)fieldToCheck)) {
            this.checkFieldForMaxLength(fieldToCheck, fieldName, validationObject.getMaxLength(), messageError);
        }
    }

    private void checkFieldForMaxLength(@NotNull String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (fieldToCheck.length() > maxLength) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_OVERSIZE_FIELD, (Object[])new Object[]{fieldName, maxLength}));
        }
    }

    protected String extractErrorField(String message) {
        return message.split("\"")[1];
    }
}

