/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class ConsentLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;
    private final RedirectIdService redirectIdService;
    private final LoggingContextService loggingContextService;
    private final PathParameterExtractor pathParameterExtractor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map<String, String> pathVariables = this.pathParameterExtractor.extractParameters(request);
        String consentId = Optional.ofNullable(pathVariables).map(pv -> (String)pv.get("consentId")).orElse(NOT_EXIST_IN_URI);
        ((TppRequestLogBuilder)TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withRequestUri().withParam("Consent ID", consentId)).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ((TppResponseLogBuilder)((TppResponseLogBuilder)TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withResponseStatus().withOptionalRedirectId(this.redirectIdService.getRedirectId()).withParam("consentStatus", this.loggingContextService.getConsentStatus())).withParam("scaStatus", this.loggingContextService.getScaStatus())).perform();
    }

    @ConstructorProperties(value={"tppService", "redirectIdService", "loggingContextService", "pathParameterExtractor"})
    public ConsentLoggingInterceptor(TppService tppService, RedirectIdService redirectIdService, LoggingContextService loggingContextService, PathParameterExtractor pathParameterExtractor) {
        this.tppService = tppService;
        this.redirectIdService = redirectIdService;
        this.loggingContextService = loggingContextService;
        this.pathParameterExtractor = pathParameterExtractor;
    }
}

