/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.PsuDataInInitialRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.SupportedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentRequestObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentRequestValidator
implements BusinessValidator<CreateConsentRequestObject> {
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ScaApproachResolver scaApproachResolver;
    private final PsuDataInInitialRequestValidator psuDataInInitialRequestValidator;
    private final SupportedAccountReferenceValidator supportedAccountReferenceValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreateConsentRequestObject requestObject) {
        ValidationResult psuDataValidationResult = this.psuDataInInitialRequestValidator.validate(requestObject.getPsuIdData());
        if (psuDataValidationResult.isNotValid()) {
            return psuDataValidationResult;
        }
        CreateConsentReq request = requestObject.getCreateConsentReq();
        ValidationResult supportedAccountReferenceValidationResult = this.supportedAccountReferenceValidator.validate((Collection<AccountReference>)request.getAccountReferences());
        if (supportedAccountReferenceValidationResult.isNotValid()) {
            return supportedAccountReferenceValidationResult;
        }
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SERVICE_INVALID_400_FOR_GLOBAL_CONSENT);
        }
        if (this.isNotSupportedBankOfferedConsent(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SERVICE_INVALID_400);
        }
        if (this.isNotSupportedAvailableAccounts(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SERVICE_INVALID_400);
        }
        if (this.isNotSupportedCombinedServiceIndicator(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SESSIONS_NOT_SUPPORTED);
        }
        if (this.isNotSupportedAccountOwnerInformation(request)) {
            return ValidationResult.invalid(ErrorType.AIS_401, TppMessageInformation.buildWithCustomError((MessageErrorCode)MessageErrorCode.CONSENT_INVALID, (String)"An explicit consent of ownerName is not supported."));
        }
        return ValidationResult.valid();
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return this.isConsentGlobal(request) && this.aspspProfileService.isGlobalConsentSupported() == false;
    }

    private boolean isNotSupportedBankOfferedConsent(CreateConsentReq request) {
        block5: {
            block4: {
                if (this.isNotEmptyAccess(request.getAccess(), request.getAisConsentData())) break block4;
                if (!Stream.of(request.getAvailableAccounts(), request.getAllPsd2(), request.getAvailableAccountsWithBalance()).anyMatch(EnumSet.of(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME)::contains)) break block5;
            }
            return false;
        }
        if (this.scaApproachResolver.resolveScaApproach() == ScaApproach.EMBEDDED) {
            return true;
        }
        return !this.aspspProfileService.isBankOfferedConsentSupported();
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess(), request.getAisConsentData()) && EnumSet.of(AccountAccessType.ALL_ACCOUNTS, AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME).contains(request.getAllPsd2());
    }

    private boolean isNotEmptyAccess(AccountAccess access, AisConsentData aisConsentData) {
        return Optional.ofNullable(access).map(ac -> ac.isNotEmpty(aisConsentData)).orElse(false);
    }

    private boolean isNotSupportedAvailableAccounts(CreateConsentReq request) {
        boolean isConsentWithoutAvailableAccounts = Stream.of(request.getAvailableAccounts(), request.getAvailableAccountsWithBalance()).allMatch(Objects::isNull);
        if (isConsentWithoutAvailableAccounts) {
            return false;
        }
        return !this.aspspProfileService.isAvailableAccountsConsentSupported();
    }

    private boolean isNotSupportedCombinedServiceIndicator(CreateConsentReq request) {
        return request.isCombinedServiceIndicator() && !this.aspspProfileService.isAisPisSessionsSupported();
    }

    private boolean isNotSupportedAccountOwnerInformation(CreateConsentReq request) {
        AccountAccess access = request.getAccess();
        AccountAccessType allAccountsWithOwnerName = AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME;
        boolean isConsentWithAdditionalInformation = Stream.of(this.isConsentWithAdditionalInformationAccess(access), request.getAvailableAccounts() == allAccountsWithOwnerName, request.getAvailableAccountsWithBalance() == allAccountsWithOwnerName, request.getAllPsd2() == allAccountsWithOwnerName).anyMatch(BooleanUtils::isTrue);
        return isConsentWithAdditionalInformation && !this.aspspProfileService.isAccountOwnerInformationSupported();
    }

    private boolean isConsentWithAdditionalInformationAccess(AccountAccess access) {
        return Optional.ofNullable(access.getAdditionalInformationAccess()).map(AdditionalInformationAccess::getOwnerName).isPresent();
    }

    @ConstructorProperties(value={"aspspProfileService", "scaApproachResolver", "psuDataInInitialRequestValidator", "supportedAccountReferenceValidator"})
    public CreateConsentRequestValidator(AspspProfileServiceWrapper aspspProfileService, ScaApproachResolver scaApproachResolver, PsuDataInInitialRequestValidator psuDataInInitialRequestValidator, SupportedAccountReferenceValidator supportedAccountReferenceValidator) {
        this.aspspProfileService = aspspProfileService;
        this.scaApproachResolver = scaApproachResolver;
        this.psuDataInInitialRequestValidator = psuDataInInitialRequestValidator;
        this.supportedAccountReferenceValidator = supportedAccountReferenceValidator;
    }
}

