/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisAuthorisationConfirmationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedirectPisScaAuthorisationService
implements PisScaAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(RedirectPisScaAuthorisationService.class);
    private final PisAuthorisationService authorisationService;
    private final Xs2aPisCommonPaymentMapper pisCommonPaymentMapper;
    private final PisAuthorisationConfirmationService pisAuthorisationConfirmationService;

    @Override
    public Optional<Xs2aCreatePisAuthorisationResponse> createCommonPaymentAuthorisation(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        return this.pisCommonPaymentMapper.mapToXsa2CreatePisAuthorisationResponse(this.authorisationService.createPisAuthorisation(paymentId, psuData), paymentType);
    }

    @Override
    public Xs2aUpdatePisCommonPaymentPsuDataResponse updateCommonPaymentPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationConfirmationService.processAuthorisationConfirmation(request);
    }

    @Override
    public void updateAuthorisation(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        this.authorisationService.updateAuthorisation(request, response);
    }

    @Override
    public void updateCancellationAuthorisation(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        this.authorisationService.updateCancellationAuthorisation(request, response);
    }

    @Override
    public Optional<Xs2aCreatePisCancellationAuthorisationResponse> createCommonPaymentCancellationAuthorisation(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        return this.pisCommonPaymentMapper.mapToXs2aCreatePisCancellationAuthorisationResponse(this.authorisationService.createPisAuthorisationCancellation(paymentId, psuData), paymentType);
    }

    @Override
    public Optional<Xs2aPaymentCancellationAuthorisationSubResource> getCancellationAuthorisationSubResources(String paymentId) {
        return this.authorisationService.getCancellationAuthorisationSubResources(paymentId).map(Xs2aPaymentCancellationAuthorisationSubResource::new);
    }

    @Override
    public Xs2aUpdatePisCommonPaymentPsuDataResponse updateCommonPaymentCancellationPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        return this.pisAuthorisationConfirmationService.processAuthorisationConfirmation(request);
    }

    @Override
    public Optional<Xs2aAuthorisationSubResources> getAuthorisationSubResources(String paymentId) {
        return this.authorisationService.getAuthorisationSubResources(paymentId).map(Xs2aAuthorisationSubResources::new);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String paymentId, String authorisationId) {
        return this.authorisationService.getAuthorisationScaStatus(paymentId, authorisationId);
    }

    @Override
    public Optional<ScaStatus> getCancellationAuthorisationScaStatus(String paymentId, String cancellationId) {
        return this.authorisationService.getCancellationAuthorisationScaStatus(paymentId, cancellationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.REDIRECT;
    }

    @ConstructorProperties(value={"authorisationService", "pisCommonPaymentMapper", "pisAuthorisationConfirmationService"})
    public RedirectPisScaAuthorisationService(PisAuthorisationService authorisationService, Xs2aPisCommonPaymentMapper pisCommonPaymentMapper, PisAuthorisationConfirmationService pisAuthorisationConfirmationService) {
        this.authorisationService = authorisationService;
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.pisAuthorisationConfirmationService = pisAuthorisationConfirmationService;
    }
}

