/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecoupledAisAuthorizationService
implements AisAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(DecoupledAisAuthorizationService.class);
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper aisConsentMapper;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!aisConsentOptional.isPresent()) {
            log.info("Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", (Object)consentId);
            return Optional.empty();
        }
        return this.aisConsentService.createAisConsentAuthorization(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            return resp;
        });
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        if (response.hasError()) {
            log.info("Consent-ID [{}], Authentication-ID [{}], PSU-ID [{}]. Update consent authorisation has failed. Error msg: {}.", new Object[]{request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData().getPsuId(), response.getErrorHolder()});
        } else {
            this.aisConsentService.updateConsentAuthorization(this.aisConsentMapper.mapToUpdateConsentPsuDataReq(request, response));
        }
        return response;
    }

    @Override
    public Optional<Authorisation> getAccountConsentAuthorizationById(String authorisationId) {
        return this.aisConsentService.getAccountConsentAuthorizationById(authorisationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.aisConsentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.DECOUPLED;
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentMapper"})
    public DecoupledAisAuthorizationService(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper aisConsentMapper) {
        this.aisConsentService = aisConsentService;
        this.aisConsentMapper = aisConsentMapper;
    }
}

