/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonDecoupledAisService {
    private static final Logger log = LoggerFactory.getLogger(CommonDecoupledAisService.class);
    private final AisConsentSpi aisConsentSpi;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aAisConsentService aisConsentService;

    public UpdateConsentPsuDataResponse proceedDecoupledApproach(String consentId, String authorisationId, SpiAccountConsent spiAccountConsent, PsuIdData psuData) {
        return this.proceedDecoupledApproach(consentId, authorisationId, spiAccountConsent, null, psuData);
    }

    public UpdateConsentPsuDataResponse proceedDecoupledApproach(String consentId, String authorisationId, SpiAccountConsent spiAccountConsent, String authenticationMethodId, PsuIdData psuData) {
        SpiResponse spiResponse = this.aisConsentSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authorisationId, authenticationMethodId, (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}], Authentication-Method-ID [{}]. Notifies a decoupled app about starting SCA when proceed decoupled approach has failed. Error msg: {}.", new Object[]{consentId, authorisationId, psuData.getPsuId(), authenticationMethodId, errorHolder});
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.aisConsentService.updateConsentAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, consentId, authorisationId, psuData);
        response.setPsuMessage(((SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload()).getPsuMessage());
        response.setChosenScaMethod(this.buildXs2aAuthenticationObjectForDecoupledApproach(authenticationMethodId));
        return response;
    }

    private AuthenticationObject buildXs2aAuthenticationObjectForDecoupledApproach(String authenticationMethodId) {
        AuthenticationObject authenticationObject = new AuthenticationObject();
        authenticationObject.setAuthenticationMethodId(authenticationMethodId);
        return authenticationObject;
    }

    @ConstructorProperties(value={"aisConsentSpi", "spiErrorMapper", "aspspConsentDataProviderFactory", "spiContextDataProvider", "aisConsentService"})
    public CommonDecoupledAisService(AisConsentSpi aisConsentSpi, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiContextDataProvider spiContextDataProvider, Xs2aAisConsentService aisConsentService) {
        this.aisConsentSpi = aisConsentSpi;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aisConsentService = aisConsentService;
    }
}

