/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.AuthorisationsList;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.UpdatePsuAuthenticationResponse;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationMapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMapper.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;
    private final AuthorisationModelMapper authorisationModelMapper;

    public Authorisations mapToAuthorisations(Xs2aAuthorisationSubResources xs2AAuthorisationSubResources) {
        Authorisations authorisations = new Authorisations();
        AuthorisationsList authorisationsList = new AuthorisationsList();
        authorisationsList.addAll(xs2AAuthorisationSubResources.getAuthorisationIds());
        authorisations.setAuthorisationIds(authorisationsList);
        return authorisations;
    }

    public Object mapToPisCreateOrUpdateAuthorisationResponse(ResponseObject responseObject) {
        Object body = responseObject.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        if (body instanceof Xs2aCreatePisAuthorisationResponse) {
            return this.authorisationModelMapper.mapToStartScaProcessResponse((Xs2aCreatePisAuthorisationResponse)body);
        }
        if (body instanceof Xs2aUpdatePisCommonPaymentPsuDataResponse) {
            Xs2aUpdatePisCommonPaymentPsuDataResponse updatePisCommonPaymentPsuDataResponse = (Xs2aUpdatePisCommonPaymentPsuDataResponse)body;
            UpdatePsuAuthenticationResponse resp = this.mapToPisUpdatePsuAuthenticationResponse(updatePisCommonPaymentPsuDataResponse);
            resp.setAuthorisationId(updatePisCommonPaymentPsuDataResponse.getAuthorisationId());
            return resp;
        }
        return null;
    }

    public Object mapToAisCreateOrUpdateAuthorisationResponse(ResponseObject<AuthorisationResponse> responseObject) {
        AuthorisationResponse body = responseObject.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        if (body instanceof CreateConsentAuthorizationResponse) {
            return this.authorisationModelMapper.mapToStartScaProcessResponse((CreateConsentAuthorizationResponse)body);
        }
        if (body instanceof UpdateConsentPsuDataResponse) {
            UpdatePsuAuthenticationResponse resp = this.mapToAisUpdatePsuAuthenticationResponse((UpdateConsentPsuDataResponse)body);
            resp.setAuthorisationId(body.getAuthorisationId());
            return resp;
        }
        return null;
    }

    @NotNull
    public ScaStatusResponse mapToScaStatusResponse(@NotNull ScaStatus scaStatus) {
        return new ScaStatusResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(scaStatus));
    }

    public UpdatePsuAuthenticationResponse mapToPisUpdatePsuAuthenticationResponse(Xs2aUpdatePisCommonPaymentPsuDataResponse response) {
        return Optional.ofNullable(response).map(r -> this.buildUpdatePsuAuthenticationResponse(r.getLinks(), r.getAvailableScaMethods(), r.getChosenScaMethod(), r.getPsuMessage(), r.getChallengeData(), r.getScaStatus())).orElse(null);
    }

    public UpdatePsuAuthenticationResponse mapToAisUpdatePsuAuthenticationResponse(UpdateConsentPsuDataResponse response) {
        return Optional.ofNullable(response).map(r -> this.buildUpdatePsuAuthenticationResponse(r.getLinks(), r.getAvailableScaMethods(), r.getChosenScaMethod(), r.getPsuMessage(), r.getChallengeData(), r.getScaStatus())).orElse(null);
    }

    public Xs2aCreatePisAuthorisationRequest mapToXs2aCreatePisAuthorisationRequest(PsuIdData psuData, String paymentId, PaymentType paymentService, String paymentProduct, Map body) {
        return new Xs2aCreatePisAuthorisationRequest(paymentId, psuData, paymentProduct, paymentService, this.mapToPasswordFromBody(body));
    }

    public String mapToPasswordFromBody(Map body) {
        return Optional.ofNullable(body).filter(bdy -> !bdy.isEmpty()).map(bdy -> bdy.get("psuData")).map(o -> (LinkedHashMap)o).map(psuDataMap -> (String)psuDataMap.get("password")).orElse(null);
    }

    private UpdatePsuAuthenticationResponse buildUpdatePsuAuthenticationResponse(Links links, List<AuthenticationObject> availableScaMethods, AuthenticationObject chosenScaMethod, String psuMessage, ChallengeData challengeData, ScaStatus scaStatus) {
        return new UpdatePsuAuthenticationResponse()._links(this.hrefLinkMapper.mapToLinksMap(links)).scaMethods(this.scaMethodsMapper.mapToScaMethods(availableScaMethods)).chosenScaMethod(this.mapToChosenScaMethod(chosenScaMethod)).psuMessage(psuMessage).challengeData(this.coreObjectsMapper.mapToChallengeData(challengeData)).scaStatus((de.adorsys.psd2.model.ScaStatus)Optional.ofNullable(scaStatus).map(s -> de.adorsys.psd2.model.ScaStatus.valueOf((String)s.name())).orElse(null));
    }

    private ChosenScaMethod mapToChosenScaMethod(AuthenticationObject authenticationObject) {
        return Optional.ofNullable(authenticationObject).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(ch.getAuthenticationType());
            method.setAuthenticationVersion(ch.getAuthenticationVersion());
            method.setName(ch.getName());
            method.setExplanation(ch.getExplanation());
            return method;
        }).orElse(null);
    }

    @ConstructorProperties(value={"coreObjectsMapper", "hrefLinkMapper", "scaMethodsMapper", "authorisationModelMapper"})
    public AuthorisationMapper(CoreObjectsMapper coreObjectsMapper, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper, AuthorisationModelMapper authorisationModelMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
        this.authorisationModelMapper = authorisationModelMapper;
    }
}

