/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class CardAccountDetailsLinks
extends AbstractLinks {
    public CardAccountDetailsLinks(String httpUrl, String accountId, Xs2aAccountAccess xs2aAccountAccess) {
        super(httpUrl);
        List<AccountReference> transactions;
        boolean isConsentGlobal = xs2aAccountAccess.getAllPsd2() != null;
        List<AccountReference> balances = xs2aAccountAccess.getBalances();
        if (this.hasAccessToCardSource(balances) && this.isValidAccountByAccess(accountId, balances, isConsentGlobal)) {
            this.setBalances(this.buildPath("/v1/card-accounts/{accountId}/balances", accountId));
        }
        if (this.hasAccessToCardSource(transactions = xs2aAccountAccess.getTransactions()) && this.isValidAccountByAccess(accountId, xs2aAccountAccess.getTransactions(), isConsentGlobal)) {
            this.setTransactions(this.buildPath("/v1/card-accounts/{accountId}/transactions", accountId));
        }
    }

    private boolean isValidAccountByAccess(String accountId, List<AccountReference> allowedAccountData, boolean isConsentGlobal) {
        return isConsentGlobal || CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> accountId.equals(a.getResourceId()));
    }

    private boolean hasAccessToCardSource(List<AccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return true;
        }
        return !references.stream().allMatch(AccountReference::isNotCardAccount);
    }
}

