/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.error;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorMapperContainer;
import de.adorsys.psd2.xs2a.web.error.ServiceUnavailableError;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class TppErrorMessageWriter {
    private static final Logger log = LoggerFactory.getLogger(TppErrorMessageWriter.class);
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final ErrorMapperContainer errorMapperContainer;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public void writeError(HttpServletResponse response, int status, TppErrorMessage tppErrorMessage) throws IOException {
        response.setStatus(status);
        response.setHeader("Content-Type", "application/json");
        ServiceType serviceType = this.serviceTypeDiscoveryService.getServiceType();
        MessageErrorCode messageErrorCode = tppErrorMessage.getCode();
        Optional byServiceTypeAndErrorCode = ErrorType.getByServiceTypeAndErrorCode((ServiceType)serviceType, (int)messageErrorCode.getCode());
        if (!byServiceTypeAndErrorCode.isPresent()) {
            throw new IllegalArgumentException("ErrorCode is not correct for given service type.");
        }
        MessageError messageError = new MessageError((ErrorType)byServiceTypeAndErrorCode.get(), new TppMessageInformation[]{TppMessageInformation.of((MessageCategory)tppErrorMessage.getCategory(), (MessageErrorCode)messageErrorCode, (Object[])tppErrorMessage.getTextParams())});
        ErrorMapperContainer.ErrorBody errorBody = this.errorMapperContainer.getErrorBody(messageError);
        this.xs2aObjectMapper.writeValue((Writer)response.getWriter(), errorBody.getBody());
    }

    public void writeServiceUnavailableError(HttpServletResponse response, String message) {
        try {
            log.warn("ResourceAccessException handled with message: {}", (Object)message);
            response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            this.xs2aObjectMapper.writeValue((Writer)response.getWriter(), (Object)new ServiceUnavailableError());
        }
        catch (IOException e) {
            log.info(" Writing to the httpServletResponse failed.");
        }
    }

    @ConstructorProperties(value={"serviceTypeDiscoveryService", "errorMapperContainer", "xs2aObjectMapper"})
    public TppErrorMessageWriter(ServiceTypeDiscoveryService serviceTypeDiscoveryService, ErrorMapperContainer errorMapperContainer, Xs2aObjectMapper xs2aObjectMapper) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.errorMapperContainer = errorMapperContainer;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

