/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class RedirectLinkBuilder {
    private static final String REDIRECT_URL = "{redirect-id}";
    private static final String ENCRYPTED_CONSENT_ID = "{encrypted-consent-id}";
    private static final String ENCRYPTED_PAYMENT_ID = "{encrypted-payment-id}";
    private static final String INTERNAL_REQUEST_ID = "{inr-id}";
    private static final String PAYMENT_SERVICE = "{payment-service}";
    private static final String PAYMENT_PRODUCT = "{payment-product}";
    private static final String PAYMENT_ID = "{payment-id}";
    private static final String CONSENT_ID = "{consentId}";
    private static final String AUTHORISATION_ID = "{authorisation-id}";
    private final AspspProfileServiceWrapper aspspProfileService;

    public String buildConsentScaRedirectLink(String encryptedConsentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getAisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_CONSENT_ID, encryptedConsentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildConsentScaOauthRedirectLink(String encryptedConsentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getOauthConfigurationUrl().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_CONSENT_ID, encryptedConsentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentScaRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getPisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentScaOauthRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getOauthConfigurationUrl().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentCancellationScaRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getPisPaymentCancellationRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPaymentCancellationScaOauthRedirectLink(String encryptedPaymentId, String redirectId, String internalRequestId) {
        return this.aspspProfileService.getOauthConfigurationUrl().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId).replace(INTERNAL_REQUEST_ID, internalRequestId);
    }

    public String buildPisConfirmationLink(String paymentService, String paymentProduct, String encryptedPaymentId, String redirectId) {
        return "/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}".replace(PAYMENT_SERVICE, paymentService).replace(PAYMENT_PRODUCT, paymentProduct).replace(PAYMENT_ID, encryptedPaymentId).replace(AUTHORISATION_ID, redirectId);
    }

    public String buildPisCancellationConfirmationLink(String paymentService, String paymentProduct, String encryptedPaymentId, String redirectId) {
        return "/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}".replace(PAYMENT_SERVICE, paymentService).replace(PAYMENT_PRODUCT, paymentProduct).replace(PAYMENT_ID, encryptedPaymentId).replace(AUTHORISATION_ID, redirectId);
    }

    public String buildAisConfirmationLink(String consentId, String redirectId) {
        return "/v1/consents/{consentId}/authorisations/{authorisation-id}".replace(CONSENT_ID, consentId).replace(AUTHORISATION_ID, redirectId);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public RedirectLinkBuilder(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

