/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.authorisation;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorisationStatusValidator {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationStatusValidator.class);

    @NotNull
    public ValidationResult validate(@NotNull ScaStatus scaStatus) {
        if (scaStatus == ScaStatus.FAILED) {
            log.info("Authorisation has failed status");
            return ValidationResult.invalid(this.getErrorType(), MessageErrorCode.STATUS_INVALID);
        }
        return ValidationResult.valid();
    }

    @NotNull
    protected abstract ErrorType getErrorType();
}

