/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AisAuthorisationValidator {
    private static final Logger log = LoggerFactory.getLogger(AisAuthorisationValidator.class);

    @NotNull
    public ValidationResult validate(@NotNull String authorisationId, @NotNull AccountConsent consent) {
        Optional<AccountConsentAuthorization> authorisationOptional = consent.findAuthorisationInConsent(authorisationId);
        if (!authorisationOptional.isPresent()) {
            log.info("Consent ID: [{}], Authorisation ID: [{}]. Authorisation validation has failed: couldn't find authorisation with given authorisationId for consent", (Object)consent.getId(), (Object)authorisationId);
            return ValidationResult.invalid(ErrorType.AIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        return ValidationResult.valid();
    }
}

