/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TransactionReportAcceptHeaderValidator {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public ValidationResult validate(String acceptHeader) {
        List<String> supportedTransactionApplicationTypes;
        if (StringUtils.isNotBlank((CharSequence)acceptHeader) && !this.isAtLeastOneAcceptHeaderSupported(supportedTransactionApplicationTypes = this.aspspProfileServiceWrapper.getSupportedTransactionApplicationTypes(), acceptHeader)) {
            return ValidationResult.invalid(ErrorType.AIS_406, MessageErrorCode.REQUESTED_FORMATS_INVALID);
        }
        return ValidationResult.valid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAtLeastOneAcceptHeaderSupported(List<String> supportedHeaders, String acceptHeader) {
        if (CollectionUtils.isEmpty(supportedHeaders)) return true;
        if (!supportedHeaders.stream().filter(Objects::nonNull).anyMatch(acceptHeader::equalsIgnoreCase)) return false;
        return true;
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public TransactionReportAcceptHeaderValidator(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

