/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountListConsentObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetCardAccountListValidator
extends AbstractAccountTppValidator<GetCardAccountListConsentObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetCardAccountListConsentObject consentObject) {
        AccountConsent accountConsent = consentObject.getAccountConsent();
        if (accountConsent.isConsentWithNotCardAccount() && !accountConsent.isConsentForAllAvailableAccounts() && !accountConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult accountConsentValidationResult = this.accountConsentValidator.validate(accountConsent, consentObject.getRequestUri());
        if (accountConsentValidationResult.isNotValid()) {
            return accountConsentValidationResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(accountConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"accountConsentValidator", "oauthConsentValidator"})
    public GetCardAccountListValidator(AccountConsentValidator accountConsentValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

