/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.piis;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error415.Error415NGPIIS;
import de.adorsys.psd2.xs2a.exception.model.error415.TppMessage415PIIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIIS415ErrorMapper
extends Psd2ErrorMapper<MessageError, Error415NGPIIS> {
    @Override
    public Function<MessageError, Error415NGPIIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.UNSUPPORTED_MEDIA_TYPE;
    }

    private Error415NGPIIS mapToPsd2Error(MessageError messageError) {
        return new Error415NGPIIS().tppMessages(this.mapToTppMessage415PIIS(messageError.getTppMessages()));
    }

    private List<TppMessage415PIIS> mapToTppMessage415PIIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage415PIIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

