/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.context;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class SpiContextDataProvider {
    private final TppService tppService;
    private final RequestProviderService requestProviderService;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;

    public SpiContextData provide() {
        return this.provideWithPsuIdData(this.requestProviderService.getPsuIdData());
    }

    public SpiContextData provideWithPsuIdData(PsuIdData psuIdData) {
        TppInfo tppInfo = this.tppService.getTppInfo();
        return this.provide(psuIdData, tppInfo);
    }

    public SpiContextData provide(PsuIdData psuIdData, TppInfo tppInfo) {
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuIdData);
        return new SpiContextData(spiPsuData, tppInfo, this.requestProviderService.getRequestId(), this.requestProviderService.getInternalRequestId(), this.requestProviderService.getOAuth2Token());
    }

    @ConstructorProperties(value={"tppService", "requestProviderService", "psuDataMapper"})
    public SpiContextDataProvider(TppService tppService, RequestProviderService requestProviderService, Xs2aToSpiPsuDataMapper psuDataMapper) {
        this.tppService = tppService;
        this.requestProviderService = requestProviderService;
        this.psuDataMapper = psuDataMapper;
    }
}

