/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.CommonPaymentObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.CreatePisCancellationAuthorisationObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.CreatePisCancellationAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.GetPaymentCancellationAuthorisationScaStatusPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.GetPaymentCancellationAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.GetPaymentCancellationAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.UpdatePisCancellationPsuDataPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.UpdatePisCancellationPsuDataValidator;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentCancellationAuthorisationServiceImpl
implements PaymentCancellationAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentCancellationAuthorisationServiceImpl.class);
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final Xs2aEventService xs2aEventService;
    private final Xs2aPisCommonPaymentService xs2aPisCommonPaymentService;
    private final CreatePisCancellationAuthorisationValidator createPisCancellationAuthorisationValidator;
    private final UpdatePisCancellationPsuDataValidator updatePisCancellationPsuDataValidator;
    private final GetPaymentCancellationAuthorisationsValidator getPaymentAuthorisationsValidator;
    private final GetPaymentCancellationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator;
    private final LoggingContextService loggingContextService;

    @Override
    public ResponseObject<CancellationAuthorisationResponse> createPisCancellationAuthorisation(Xs2aCreatePisAuthorisationRequest request) {
        ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> cancellationAuthorisation = this.createCancellationAuthorisation(request.getPaymentId(), request.getPsuData(), request.getPaymentService(), request.getPaymentProduct());
        if (cancellationAuthorisation.hasError()) {
            return ResponseObject.builder().fail(cancellationAuthorisation.getError()).build();
        }
        if (request.hasNoUpdateData()) {
            return ResponseObject.builder().body(cancellationAuthorisation.getBody()).build();
        }
        String cancellationId = cancellationAuthorisation.getBody().getCancellationId();
        Xs2aUpdatePisCommonPaymentPsuDataRequest updateRequest = new Xs2aUpdatePisCommonPaymentPsuDataRequest(request, cancellationId);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePsuDataResponse = this.updatePisCancellationPsuData(updateRequest);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    @Override
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCancellationPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        String paymentId = request.getPaymentId();
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_REQUEST_RECEIVED, request);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.xs2aPisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponseOptional.isPresent()) {
            log.info("Payment-ID [{}]. Update PIS Cancellation PSU Data has failed. Payment not found by id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentResponseOptional.get();
        this.loggingContextService.storeTransactionStatus(pisCommonPaymentResponse.getTransactionStatus());
        ValidationResult validationResult = this.updatePisCancellationPsuDataValidator.validate(new UpdatePisCancellationPsuDataPO(pisCommonPaymentResponse, request));
        if (validationResult.isNotValid()) {
            MessageErrorCode messageErrorCode = validationResult.getMessageError().getTppMessage().getMessageErrorCode();
            if (EnumSet.of(MessageErrorCode.PSU_CREDENTIALS_INVALID, MessageErrorCode.FORMAT_ERROR_NO_PSU).contains(messageErrorCode)) {
                this.xs2aPisCommonPaymentService.updatePisAuthorisationStatus(request.getAuthorisationId(), ScaStatus.FAILED);
            }
            log.info("Payment-ID [{}], Authorisation-ID [{}]. Update PIS cancellation authorisation - validation failed: {}", new Object[]{paymentId, request.getAuthorisationId(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService(request.getAuthorisationId());
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = pisScaAuthorisationService.updateCommonPaymentCancellationPsuData(request);
        this.loggingContextService.storeScaStatus(response.getScaStatus());
        return response.hasError() ? ResponseObject.builder().fail(response.getErrorHolder()).build() : ResponseObject.builder().body(response).build();
    }

    @Override
    public ResponseObject<Xs2aPaymentCancellationAuthorisationSubResource> getPaymentInitiationCancellationAuthorisationInformation(String paymentId, PaymentType paymentType, String paymentProduct) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_CANCELLATION_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.xs2aPisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            log.info("Payment-ID [{}]. Get information PIS Cancellation Authorisation has failed. Payment not found by id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        this.loggingContextService.storeTransactionStatus(pisCommonPaymentResponse.get().getTransactionStatus());
        ValidationResult validationResult = this.getPaymentAuthorisationsValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse.get(), paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get information PIS cancellation authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        return pisScaAuthorisationService.getCancellationAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aPaymentCancellationAuthorisationSubResource)resp).build()).orElseGet(() -> {
            log.info("Payment-ID [{}]. Get information PIS Cancellation Authorisation has failed. Authorisation not found by payment id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    @Override
    public ResponseObject<ScaStatus> getPaymentCancellationAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_CANCELLATION_SCA_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.xs2aPisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponseOptional.isPresent()) {
            log.info("Payment-ID [{}]. Get SCA status PIS Cancellation Authorisation has failed. Payment not found by id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentResponseOptional.get();
        ValidationResult validationResult = this.getPaymentAuthorisationScaStatusValidator.validate(new GetPaymentCancellationAuthorisationScaStatusPO(pisCommonPaymentResponse, authorisationId, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Get SCA status PIS cancellation authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService(authorisationId);
        Optional<ScaStatus> scaStatusOptional = pisScaAuthorisationService.getCancellationAuthorisationScaStatus(paymentId, authorisationId);
        if (!scaStatusOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        ScaStatus scaStatus = scaStatusOptional.get();
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPaymentResponse.getTransactionStatus(), scaStatus);
        return ResponseObject.builder().body(scaStatus).build();
    }

    private ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> createCancellationAuthorisation(String paymentId, PsuIdData psuData, PaymentType paymentType, String paymentProduct) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_CANCELLATION_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.xs2aPisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponseOptional.isPresent()) {
            log.info("Payment-ID [{}]. Create PIS Cancellation Authorization has failed. Payment not found by id.", (Object)paymentId);
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        ValidationResult validationResult = this.createPisCancellationAuthorisationValidator.validate(new CreatePisCancellationAuthorisationObject(pisCommonPaymentResponseOptional.get(), psuData, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("Payment-ID [{}]. Create PIS Cancellation Authorisation - validation failed: {}", (Object)paymentId, (Object)validationResult.getMessageError());
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        Optional<Xs2aCreatePisCancellationAuthorisationResponse> createAuthorisationResponseOptional = pisScaAuthorisationService.createCommonPaymentCancellationAuthorisation(paymentId, paymentType, psuData);
        if (!createAuthorisationResponseOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR)).build();
        }
        Xs2aCreatePisCancellationAuthorisationResponse createAuthorisationResponse = createAuthorisationResponseOptional.get();
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPaymentResponseOptional.get().getTransactionStatus(), createAuthorisationResponse.getScaStatus());
        return ResponseObject.builder().body(createAuthorisationResponse).build();
    }

    @ConstructorProperties(value={"pisScaAuthorisationServiceResolver", "xs2aEventService", "xs2aPisCommonPaymentService", "createPisCancellationAuthorisationValidator", "updatePisCancellationPsuDataValidator", "getPaymentAuthorisationsValidator", "getPaymentAuthorisationScaStatusValidator", "loggingContextService"})
    public PaymentCancellationAuthorisationServiceImpl(PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, Xs2aEventService xs2aEventService, Xs2aPisCommonPaymentService xs2aPisCommonPaymentService, CreatePisCancellationAuthorisationValidator createPisCancellationAuthorisationValidator, UpdatePisCancellationPsuDataValidator updatePisCancellationPsuDataValidator, GetPaymentCancellationAuthorisationsValidator getPaymentAuthorisationsValidator, GetPaymentCancellationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator, LoggingContextService loggingContextService) {
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.xs2aEventService = xs2aEventService;
        this.xs2aPisCommonPaymentService = xs2aPisCommonPaymentService;
        this.createPisCancellationAuthorisationValidator = createPisCancellationAuthorisationValidator;
        this.updatePisCancellationPsuDataValidator = updatePisCancellationPsuDataValidator;
        this.getPaymentAuthorisationsValidator = getPaymentAuthorisationsValidator;
        this.getPaymentAuthorisationScaStatusValidator = getPaymentAuthorisationScaStatusValidator;
        this.loggingContextService = loggingContextService;
    }
}

