/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.xs2a.core.pis.PurposeCode;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.Size;

@ApiModel(description="TransactionsCreditorResponse information", value="TransactionsCreditorResponse")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transactions {
    @ApiModelProperty(value="Can be used as access-ID in the API, where more details on an transaction is offered.", required=false, example="1234567")
    @Size(max=35)
    private @Size(max=35) String transactionId;
    @ApiModelProperty(value="Identifier of the transaction as used e.g. for reference for deltafunction on application level. The same identification as for example used within camt.05x messages.", example="12345")
    @Size(max=35)
    private @Size(max=35) String entryReference;
    @ApiModelProperty(value="End to end id", required=false, example="123456789")
    @Size(max=35)
    private @Size(max=35) String endToEndId;
    @ApiModelProperty(value="Identifier of Mandates, e.g. a SEPA Mandate ID", required=false, example="12345")
    @Size(max=35)
    private @Size(max=35) String mandateId;
    @ApiModelProperty(value="Identifier of a Cheque", example="1234567")
    @Size(max=35)
    private @Size(max=35) String checkId;
    @ApiModelProperty(value="Identifier of Creditors, e.g. a SEPA Creditor ID", required=false, example="12345")
    @Size(max=35)
    private @Size(max=35) String creditorId;
    @ApiModelProperty(value="Booking Date", example="2017-01-01")
    private LocalDate bookingDate;
    @ApiModelProperty(value="Value Date", example="2017-01-01")
    private LocalDate valueDate;
    @ApiModelProperty(value="Amount", required=true)
    private Xs2aAmount amount;
    @ApiModelProperty(value="Array of Exchange Rate")
    private List<Xs2aExchangeRate> exchangeRate;
    @ApiModelProperty(value="Name of the Creditor if a debited transaction", example="John Miles")
    @Size(max=70)
    private @Size(max=70) String creditorName;
    @ApiModelProperty(value="Creditor account")
    private AccountReference creditorAccount;
    @ApiModelProperty(value="Creditor agent")
    private String creditorAgent;
    @ApiModelProperty(value="Name of the last creditor", example="Paul Simpson")
    @Size(max=70)
    private @Size(max=70) String ultimateCreditor;
    @ApiModelProperty(value="Name of the debtor if a \u201cCredited\u201d transaction", example="Jan")
    private String debtorName;
    @ApiModelProperty(value="Debtor account")
    private AccountReference debtorAccount;
    @ApiModelProperty(value="Debtor agent")
    private String debtorAgent;
    @ApiModelProperty(value="Name of the last debtor", example="Max")
    @Size(max=70)
    private @Size(max=70) String ultimateDebtor;
    @ApiModelProperty(value="Remittance information unstructured", example="Ref Number Merchant")
    @Size(max=140)
    private @Size(max=140) String remittanceInformationUnstructured;
    @ApiModelProperty(value="Remittance information structured;", example="Ref Number Merchant")
    @Size(max=140)
    private @Size(max=140) String remittanceInformationStructured;
    @ApiModelProperty(value="Purpose code")
    private PurposeCode purposeCode;
    @ApiModelProperty(value="Bank transaction code as used by the ASPSP in ISO20022 related formats.")
    private BankTransactionCode bankTransactionCodeCode;
    @ApiModelProperty(value="Proprietary bank transaction code as used within a community or within an ASPSP e.g. for MT94x based transaction reports", example="12345")
    @Size(max=35)
    private @Size(max=35) String proprietaryBankTransactionCode;
    @ApiModelProperty(value="Is used if and only if the bookingStatus entry equals \"information\". Every active standing order related to the dedicated payment account result into one entry.")
    private Xs2aAdditionalInformationStructured additionalInformationStructured;
    @ApiModelProperty(value="Balance after transaction")
    private Xs2aBalance balanceAfterTransaction;
    @ApiModelProperty(value="The following links could be used for retrieving details of a transaction")
    @JsonProperty(value="_links")
    private Links links = new Links();

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getEntryReference() {
        return this.entryReference;
    }

    public String getEndToEndId() {
        return this.endToEndId;
    }

    public String getMandateId() {
        return this.mandateId;
    }

    public String getCheckId() {
        return this.checkId;
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public Xs2aAmount getAmount() {
        return this.amount;
    }

    public List<Xs2aExchangeRate> getExchangeRate() {
        return this.exchangeRate;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public String getDebtorAgent() {
        return this.debtorAgent;
    }

    public String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public BankTransactionCode getBankTransactionCodeCode() {
        return this.bankTransactionCodeCode;
    }

    public String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public Xs2aAdditionalInformationStructured getAdditionalInformationStructured() {
        return this.additionalInformationStructured;
    }

    public Xs2aBalance getBalanceAfterTransaction() {
        return this.balanceAfterTransaction;
    }

    public Links getLinks() {
        return this.links;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setEntryReference(String entryReference) {
        this.entryReference = entryReference;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public void setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
    }

    public void setAmount(Xs2aAmount amount) {
        this.amount = amount;
    }

    public void setExchangeRate(List<Xs2aExchangeRate> exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public void setDebtorAgent(String debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public void setBankTransactionCodeCode(BankTransactionCode bankTransactionCodeCode) {
        this.bankTransactionCodeCode = bankTransactionCodeCode;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public void setAdditionalInformationStructured(Xs2aAdditionalInformationStructured additionalInformationStructured) {
        this.additionalInformationStructured = additionalInformationStructured;
    }

    public void setBalanceAfterTransaction(Xs2aBalance balanceAfterTransaction) {
        this.balanceAfterTransaction = balanceAfterTransaction;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transactions)) {
            return false;
        }
        Transactions other = (Transactions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$entryReference = this.getEntryReference();
        String other$entryReference = other.getEntryReference();
        if (this$entryReference == null ? other$entryReference != null : !this$entryReference.equals(other$entryReference)) {
            return false;
        }
        String this$endToEndId = this.getEndToEndId();
        String other$endToEndId = other.getEndToEndId();
        if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
            return false;
        }
        String this$mandateId = this.getMandateId();
        String other$mandateId = other.getMandateId();
        if (this$mandateId == null ? other$mandateId != null : !this$mandateId.equals(other$mandateId)) {
            return false;
        }
        String this$checkId = this.getCheckId();
        String other$checkId = other.getCheckId();
        if (this$checkId == null ? other$checkId != null : !this$checkId.equals(other$checkId)) {
            return false;
        }
        String this$creditorId = this.getCreditorId();
        String other$creditorId = other.getCreditorId();
        if (this$creditorId == null ? other$creditorId != null : !this$creditorId.equals(other$creditorId)) {
            return false;
        }
        LocalDate this$bookingDate = this.getBookingDate();
        LocalDate other$bookingDate = other.getBookingDate();
        if (this$bookingDate == null ? other$bookingDate != null : !((Object)this$bookingDate).equals(other$bookingDate)) {
            return false;
        }
        LocalDate this$valueDate = this.getValueDate();
        LocalDate other$valueDate = other.getValueDate();
        if (this$valueDate == null ? other$valueDate != null : !((Object)this$valueDate).equals(other$valueDate)) {
            return false;
        }
        Xs2aAmount this$amount = this.getAmount();
        Xs2aAmount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        List<Xs2aExchangeRate> this$exchangeRate = this.getExchangeRate();
        List<Xs2aExchangeRate> other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        AccountReference this$creditorAccount = this.getCreditorAccount();
        AccountReference other$creditorAccount = other.getCreditorAccount();
        if (this$creditorAccount == null ? other$creditorAccount != null : !this$creditorAccount.equals(other$creditorAccount)) {
            return false;
        }
        String this$creditorAgent = this.getCreditorAgent();
        String other$creditorAgent = other.getCreditorAgent();
        if (this$creditorAgent == null ? other$creditorAgent != null : !this$creditorAgent.equals(other$creditorAgent)) {
            return false;
        }
        String this$ultimateCreditor = this.getUltimateCreditor();
        String other$ultimateCreditor = other.getUltimateCreditor();
        if (this$ultimateCreditor == null ? other$ultimateCreditor != null : !this$ultimateCreditor.equals(other$ultimateCreditor)) {
            return false;
        }
        String this$debtorName = this.getDebtorName();
        String other$debtorName = other.getDebtorName();
        if (this$debtorName == null ? other$debtorName != null : !this$debtorName.equals(other$debtorName)) {
            return false;
        }
        AccountReference this$debtorAccount = this.getDebtorAccount();
        AccountReference other$debtorAccount = other.getDebtorAccount();
        if (this$debtorAccount == null ? other$debtorAccount != null : !this$debtorAccount.equals(other$debtorAccount)) {
            return false;
        }
        String this$debtorAgent = this.getDebtorAgent();
        String other$debtorAgent = other.getDebtorAgent();
        if (this$debtorAgent == null ? other$debtorAgent != null : !this$debtorAgent.equals(other$debtorAgent)) {
            return false;
        }
        String this$ultimateDebtor = this.getUltimateDebtor();
        String other$ultimateDebtor = other.getUltimateDebtor();
        if (this$ultimateDebtor == null ? other$ultimateDebtor != null : !this$ultimateDebtor.equals(other$ultimateDebtor)) {
            return false;
        }
        String this$remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        String other$remittanceInformationUnstructured = other.getRemittanceInformationUnstructured();
        if (this$remittanceInformationUnstructured == null ? other$remittanceInformationUnstructured != null : !this$remittanceInformationUnstructured.equals(other$remittanceInformationUnstructured)) {
            return false;
        }
        String this$remittanceInformationStructured = this.getRemittanceInformationStructured();
        String other$remittanceInformationStructured = other.getRemittanceInformationStructured();
        if (this$remittanceInformationStructured == null ? other$remittanceInformationStructured != null : !this$remittanceInformationStructured.equals(other$remittanceInformationStructured)) {
            return false;
        }
        PurposeCode this$purposeCode = this.getPurposeCode();
        PurposeCode other$purposeCode = other.getPurposeCode();
        if (this$purposeCode == null ? other$purposeCode != null : !this$purposeCode.equals(other$purposeCode)) {
            return false;
        }
        BankTransactionCode this$bankTransactionCodeCode = this.getBankTransactionCodeCode();
        BankTransactionCode other$bankTransactionCodeCode = other.getBankTransactionCodeCode();
        if (this$bankTransactionCodeCode == null ? other$bankTransactionCodeCode != null : !((Object)this$bankTransactionCodeCode).equals(other$bankTransactionCodeCode)) {
            return false;
        }
        String this$proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        String other$proprietaryBankTransactionCode = other.getProprietaryBankTransactionCode();
        if (this$proprietaryBankTransactionCode == null ? other$proprietaryBankTransactionCode != null : !this$proprietaryBankTransactionCode.equals(other$proprietaryBankTransactionCode)) {
            return false;
        }
        Xs2aAdditionalInformationStructured this$additionalInformationStructured = this.getAdditionalInformationStructured();
        Xs2aAdditionalInformationStructured other$additionalInformationStructured = other.getAdditionalInformationStructured();
        if (this$additionalInformationStructured == null ? other$additionalInformationStructured != null : !((Object)this$additionalInformationStructured).equals(other$additionalInformationStructured)) {
            return false;
        }
        Xs2aBalance this$balanceAfterTransaction = this.getBalanceAfterTransaction();
        Xs2aBalance other$balanceAfterTransaction = other.getBalanceAfterTransaction();
        if (this$balanceAfterTransaction == null ? other$balanceAfterTransaction != null : !((Object)this$balanceAfterTransaction).equals(other$balanceAfterTransaction)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transactions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $entryReference = this.getEntryReference();
        result = result * 59 + ($entryReference == null ? 43 : $entryReference.hashCode());
        String $endToEndId = this.getEndToEndId();
        result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
        String $mandateId = this.getMandateId();
        result = result * 59 + ($mandateId == null ? 43 : $mandateId.hashCode());
        String $checkId = this.getCheckId();
        result = result * 59 + ($checkId == null ? 43 : $checkId.hashCode());
        String $creditorId = this.getCreditorId();
        result = result * 59 + ($creditorId == null ? 43 : $creditorId.hashCode());
        LocalDate $bookingDate = this.getBookingDate();
        result = result * 59 + ($bookingDate == null ? 43 : ((Object)$bookingDate).hashCode());
        LocalDate $valueDate = this.getValueDate();
        result = result * 59 + ($valueDate == null ? 43 : ((Object)$valueDate).hashCode());
        Xs2aAmount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        List<Xs2aExchangeRate> $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        AccountReference $creditorAccount = this.getCreditorAccount();
        result = result * 59 + ($creditorAccount == null ? 43 : $creditorAccount.hashCode());
        String $creditorAgent = this.getCreditorAgent();
        result = result * 59 + ($creditorAgent == null ? 43 : $creditorAgent.hashCode());
        String $ultimateCreditor = this.getUltimateCreditor();
        result = result * 59 + ($ultimateCreditor == null ? 43 : $ultimateCreditor.hashCode());
        String $debtorName = this.getDebtorName();
        result = result * 59 + ($debtorName == null ? 43 : $debtorName.hashCode());
        AccountReference $debtorAccount = this.getDebtorAccount();
        result = result * 59 + ($debtorAccount == null ? 43 : $debtorAccount.hashCode());
        String $debtorAgent = this.getDebtorAgent();
        result = result * 59 + ($debtorAgent == null ? 43 : $debtorAgent.hashCode());
        String $ultimateDebtor = this.getUltimateDebtor();
        result = result * 59 + ($ultimateDebtor == null ? 43 : $ultimateDebtor.hashCode());
        String $remittanceInformationUnstructured = this.getRemittanceInformationUnstructured();
        result = result * 59 + ($remittanceInformationUnstructured == null ? 43 : $remittanceInformationUnstructured.hashCode());
        String $remittanceInformationStructured = this.getRemittanceInformationStructured();
        result = result * 59 + ($remittanceInformationStructured == null ? 43 : $remittanceInformationStructured.hashCode());
        PurposeCode $purposeCode = this.getPurposeCode();
        result = result * 59 + ($purposeCode == null ? 43 : $purposeCode.hashCode());
        BankTransactionCode $bankTransactionCodeCode = this.getBankTransactionCodeCode();
        result = result * 59 + ($bankTransactionCodeCode == null ? 43 : ((Object)$bankTransactionCodeCode).hashCode());
        String $proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        result = result * 59 + ($proprietaryBankTransactionCode == null ? 43 : $proprietaryBankTransactionCode.hashCode());
        Xs2aAdditionalInformationStructured $additionalInformationStructured = this.getAdditionalInformationStructured();
        result = result * 59 + ($additionalInformationStructured == null ? 43 : ((Object)$additionalInformationStructured).hashCode());
        Xs2aBalance $balanceAfterTransaction = this.getBalanceAfterTransaction();
        result = result * 59 + ($balanceAfterTransaction == null ? 43 : ((Object)$balanceAfterTransaction).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public String toString() {
        return "Transactions(transactionId=" + this.getTransactionId() + ", entryReference=" + this.getEntryReference() + ", endToEndId=" + this.getEndToEndId() + ", mandateId=" + this.getMandateId() + ", checkId=" + this.getCheckId() + ", creditorId=" + this.getCreditorId() + ", bookingDate=" + this.getBookingDate() + ", valueDate=" + this.getValueDate() + ", amount=" + this.getAmount() + ", exchangeRate=" + this.getExchangeRate() + ", creditorName=" + this.getCreditorName() + ", creditorAccount=" + this.getCreditorAccount() + ", creditorAgent=" + this.getCreditorAgent() + ", ultimateCreditor=" + this.getUltimateCreditor() + ", debtorName=" + this.getDebtorName() + ", debtorAccount=" + this.getDebtorAccount() + ", debtorAgent=" + this.getDebtorAgent() + ", ultimateDebtor=" + this.getUltimateDebtor() + ", remittanceInformationUnstructured=" + this.getRemittanceInformationUnstructured() + ", remittanceInformationStructured=" + this.getRemittanceInformationStructured() + ", purposeCode=" + this.getPurposeCode() + ", bankTransactionCodeCode=" + this.getBankTransactionCodeCode() + ", proprietaryBankTransactionCode=" + this.getProprietaryBankTransactionCode() + ", additionalInformationStructured=" + this.getAdditionalInformationStructured() + ", balanceAfterTransaction=" + this.getBalanceAfterTransaction() + ", links=" + this.getLinks() + ")";
    }
}

