/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.piis;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AccountReferenceValidator;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.CurrencyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.piis.FundsConfirmationBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements FundsConfirmationBodyValidator {
    private final AccountReferenceValidator accountReferenceValidator;
    private final AmountValidator amountValidator;
    private final CurrencyValidator currencyValidator;
    private final FieldExtractor fieldExtractor;

    public FundsConfirmationBodyValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, AccountReferenceValidator accountReferenceValidator, AmountValidator amountValidator, CurrencyValidator currencyValidator, FieldExtractor fieldExtractor) {
        super(errorBuildingService, xs2aObjectMapper);
        this.accountReferenceValidator = accountReferenceValidator;
        this.amountValidator = amountValidator;
        this.currencyValidator = currencyValidator;
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        Optional<ConfirmationOfFunds> confirmationOfFundsOptional = this.fieldExtractor.mapBodyToInstance(request, messageError, ConfirmationOfFunds.class);
        if (!confirmationOfFundsOptional.isPresent()) {
            return messageError;
        }
        ConfirmationOfFunds confirmationOfFunds = confirmationOfFundsOptional.get();
        if (confirmationOfFunds.getAccount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"access"}));
        } else {
            this.accountReferenceValidator.validate(confirmationOfFunds.getAccount(), messageError);
        }
        if (confirmationOfFunds.getInstructedAmount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"instructedAmount"}));
        } else {
            this.validateAmount(confirmationOfFunds.getInstructedAmount(), messageError);
        }
        return messageError;
    }

    private void validateAmount(Amount instructedAmount, MessageError messageError) {
        this.currencyValidator.validateCurrency(instructedAmount.getCurrency(), messageError);
        this.amountValidator.validateAmount(instructedAmount.getAmount(), messageError);
    }
}

