/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import de.adorsys.psd2.xs2a.web.request.RequestPathResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OauthModeFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(OauthModeFilter.class);
    private static final Map<String, List<String>> OAUTH2_ENDPOINTS_WITH_METHODS = new HashMap<String, List<String>>();
    private static final List<String> OAUTH2_GET_ENDPOINTS_WITH_METHODS = new ArrayList<String>();
    private final AspspProfileServiceWrapper aspspProfileService;
    private final RequestProviderService requestProviderService;
    private final ScaApproachResolver scaApproachResolver;
    private final TppErrorMessageWriter tppErrorMessageWriter;
    private final RequestPathResolver requestPathResolver;

    public OauthModeFilter(TppErrorMessageWriter tppErrorMessageWriter, AspspProfileServiceWrapper aspspProfileService, RequestProviderService requestProviderService, ScaApproachResolver scaApproachResolver, TppErrorMessageWriter tppErrorMessageWriter1, RequestPathResolver requestPathResolver, Xs2aEndpointChecker xs2aEndpointChecker) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
        this.scaApproachResolver = scaApproachResolver;
        this.tppErrorMessageWriter = tppErrorMessageWriter1;
        this.requestPathResolver = requestPathResolver;
    }

    @Override
    protected void doFilterInternalCustom(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.shouldFilterInternal(request)) {
            if (this.isRedirectApproachWithGivenOauthType(ScaRedirectFlow.OAUTH_PRE_STEP) && this.requestProviderService.getOAuth2Token() == null) {
                log.info("OAuth pre-step selected, no authorisation header is present in the request");
                this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, MessageErrorCode.UNAUTHORIZED_NO_TOKEN, this.aspspProfileService.getOauthConfigurationUrl()));
                return;
            }
            if (this.isRedirectApproachWithGivenOauthType(ScaRedirectFlow.OAUTH) && StringUtils.isNotBlank((CharSequence)this.requestProviderService.getOAuth2Token())) {
                log.info("OAuth integrated selected, authorisation header is present in the request");
                this.tppErrorMessageWriter.writeError(response, new TppErrorMessage(MessageCategory.ERROR, MessageErrorCode.FORBIDDEN, new Object[0]));
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean shouldFilterInternal(HttpServletRequest request) {
        return !this.shouldNotFilterInternal(request);
    }

    private boolean shouldNotFilterInternal(HttpServletRequest request) {
        String requestPath = this.requestPathResolver.resolveRequestPath(request);
        if (this.isRedirectApproachWithGivenOauthType(ScaRedirectFlow.OAUTH_PRE_STEP) && request.getMethod().equals("GET")) {
            return OAUTH2_GET_ENDPOINTS_WITH_METHODS.stream().noneMatch(requestPath::startsWith);
        }
        return OAUTH2_ENDPOINTS_WITH_METHODS.entrySet().stream().filter(entry -> requestPath.startsWith((String)entry.getKey())).noneMatch(entry -> ((List)entry.getValue()).contains(request.getMethod()));
    }

    private boolean isRedirectApproachWithGivenOauthType(ScaRedirectFlow scaRedirectFlow) {
        return this.scaApproachResolver.resolveScaApproach() == ScaApproach.REDIRECT && this.aspspProfileService.getScaRedirectFlow() == scaRedirectFlow;
    }

    static {
        OAUTH2_ENDPOINTS_WITH_METHODS.put("/v1/payments", Arrays.asList("POST", "DELETE"));
        OAUTH2_ENDPOINTS_WITH_METHODS.put("/v1/bulk-payments", Arrays.asList("POST", "DELETE"));
        OAUTH2_ENDPOINTS_WITH_METHODS.put("/v1/periodic-payments", Arrays.asList("POST", "DELETE"));
        OAUTH2_ENDPOINTS_WITH_METHODS.put("/v1/consents", Collections.singletonList("POST"));
        OAUTH2_GET_ENDPOINTS_WITH_METHODS.add("/v1/payments");
        OAUTH2_GET_ENDPOINTS_WITH_METHODS.add("/v1/bulk-payments");
        OAUTH2_GET_ENDPOINTS_WITH_METHODS.add("/v1/periodic-payments");
        OAUTH2_GET_ENDPOINTS_WITH_METHODS.add("/v1/consents");
    }
}

