/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessMultipleAccountsValidator {
    public ValidationResult validate(AccountConsent accountConsent, boolean withBalance) {
        if (withBalance && accountConsent.isConsentForDedicatedAccounts()) {
            Xs2aAccountAccess access = accountConsent.getAccess();
            return this.validateAccountReferenceSize(access.getAccounts(), access.getBalances()) ? ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID) : ValidationResult.valid();
        }
        return ValidationResult.valid();
    }

    private boolean validateAccountReferenceSize(List<AccountReference> accounts, List<AccountReference> balances) {
        List filteredAccountReferences = accounts.stream().filter(AccountReference::isNotCardAccount).collect(Collectors.toList());
        return CollectionUtils.isNotEmpty(filteredAccountReferences) && CollectionUtils.isNotEmpty(balances) && filteredAccountReferences.size() > balances.size();
    }
}

