/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.PermittedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetAccountDetailsValidator
extends AbstractAccountTppValidator<CommonAccountRequestObject> {
    private final PermittedAccountReferenceValidator permittedAccountReferenceValidator;
    private final AccountConsentValidator accountConsentValidator;
    private final AccountAccessValidator accountAccessValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CommonAccountRequestObject commonAccountRequestObject) {
        AccountConsent accountConsent = commonAccountRequestObject.getAccountConsent();
        if (accountConsent.isConsentWithNotIbanAccount() && !accountConsent.isConsentForAllAvailableAccounts() && !accountConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountConsent.getAccess(), commonAccountRequestObject.getAccounts(), commonAccountRequestObject.getAccountId(), accountConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        ValidationResult permittedAccountReferenceValidationResult = this.permittedAccountReferenceValidator.validate(accountConsent, commonAccountRequestObject.getAccountId(), commonAccountRequestObject.isWithBalance());
        if (permittedAccountReferenceValidationResult.isNotValid()) {
            return permittedAccountReferenceValidationResult;
        }
        ValidationResult accountAccessValidationResult = this.accountAccessValidator.validate(commonAccountRequestObject.getAccountConsent(), commonAccountRequestObject.isWithBalance());
        if (accountAccessValidationResult.isNotValid()) {
            return accountAccessValidationResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(accountConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, commonAccountRequestObject.getRequestUri());
    }

    @ConstructorProperties(value={"permittedAccountReferenceValidator", "accountConsentValidator", "accountAccessValidator", "accountReferenceAccessValidator", "oauthConsentValidator"})
    public GetAccountDetailsValidator(PermittedAccountReferenceValidator permittedAccountReferenceValidator, AccountConsentValidator accountConsentValidator, AccountAccessValidator accountAccessValidator, AccountReferenceAccessValidator accountReferenceAccessValidator, OauthConsentValidator oauthConsentValidator) {
        this.permittedAccountReferenceValidator = permittedAccountReferenceValidator;
        this.accountConsentValidator = accountConsentValidator;
        this.accountAccessValidator = accountAccessValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

