/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.DownloadTransactionListRequestObject;
import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DownloadTransactionsReportValidator
extends AbstractAccountTppValidator<DownloadTransactionListRequestObject> {
    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(DownloadTransactionListRequestObject consentObject) {
        AccountConsent accountConsent = consentObject.getAccountConsent();
        if (LocalDate.now().compareTo(accountConsent.getValidUntil()) > 0) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_EXPIRED);
        }
        ConsentStatus consentStatus = accountConsent.getConsentStatus();
        if (consentStatus != ConsentStatus.VALID) {
            MessageErrorCode messageErrorCode = consentStatus == ConsentStatus.RECEIVED ? MessageErrorCode.CONSENT_INVALID : MessageErrorCode.CONSENT_EXPIRED;
            return ValidationResult.invalid(ErrorType.AIS_401, messageErrorCode);
        }
        return ValidationResult.valid();
    }
}

