/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.consent;

import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentAuthorisationMapper {
    private final TppRedirectUriMapper tppRedirectUriMapper;

    public CreateAuthorisationRequest mapToAuthorisationRequest(ScaStatus scaStatus, PsuIdData psuData, ScaApproach scaApproach, String tppRedirectURI, String tppNOKRedirectURI) {
        return Optional.ofNullable(scaStatus).map(st -> {
            CreateAuthorisationRequest consentAuthorization = new CreateAuthorisationRequest();
            consentAuthorization.setPsuData(psuData);
            consentAuthorization.setScaApproach(scaApproach);
            consentAuthorization.setTppRedirectURIs(this.tppRedirectUriMapper.mapToTppRedirectUri(tppRedirectURI, tppNOKRedirectURI));
            return consentAuthorization;
        }).orElse(null);
    }

    public UpdateAuthorisationRequest mapToAuthorisationRequest(UpdateConsentPsuDataReq updatePsuData) {
        return Optional.ofNullable(updatePsuData).map(data -> {
            UpdateAuthorisationRequest consentAuthorization = new UpdateAuthorisationRequest();
            consentAuthorization.setPsuData(data.getPsuData());
            consentAuthorization.setScaStatus(data.getScaStatus());
            consentAuthorization.setAuthenticationMethodId(data.getAuthenticationMethodId());
            consentAuthorization.setPassword(data.getPassword());
            consentAuthorization.setScaAuthenticationData(data.getScaAuthenticationData());
            consentAuthorization.setAuthorisationType(AuthorisationType.AIS);
            return consentAuthorization;
        }).orElse(null);
    }

    @ConstructorProperties(value={"tppRedirectUriMapper"})
    public Xs2aAisConsentAuthorisationMapper(TppRedirectUriMapper tppRedirectUriMapper) {
        this.tppRedirectUriMapper = tppRedirectUriMapper;
    }
}

