/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.consent.CardAccountHandler;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AccountReferenceInConsentUpdater {
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final CardAccountHandler cardAccountHandler;

    public void rewriteAccountAccess(@NotNull String consentId, @NotNull Xs2aAccountAccess newAccountAccess) {
        this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(newAccountAccess));
    }

    public CmsResponse<AccountConsent> updateAccountReferences(@NotNull String consentId, @NotNull Xs2aAccountAccess existingAccess, @NotNull List<Xs2aAccountDetails> accountDetails) {
        ArrayList<AccountReference> accounts = new ArrayList<AccountReference>();
        ArrayList<AccountReference> transactions = new ArrayList<AccountReference>();
        ArrayList<AccountReference> balances = new ArrayList<AccountReference>();
        ArrayList<AccountReference> ownerName = new ArrayList<AccountReference>();
        AdditionalInformationAccess additionalInformationAccess = existingAccess.getAdditionalInformationAccess();
        if (existingAccess.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS) {
            accounts.addAll(this.enrichAccountReferencesGlobal(accountDetails));
            transactions.addAll(this.enrichAccountReferencesGlobal(accountDetails));
            balances.addAll(this.enrichAccountReferencesGlobal(accountDetails));
        } else {
            for (Xs2aAccountDetails accountDetail : accountDetails) {
                accounts.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getAccounts()));
                balances.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getBalances()));
                transactions.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getTransactions()));
            }
        }
        for (Xs2aAccountDetails accountDetail : accountDetails) {
            if (additionalInformationAccess == null || additionalInformationAccess.getOwnerName() == null) continue;
            ownerName.addAll(this.enrichAccountReferences(accountDetail, additionalInformationAccess.getOwnerName()));
        }
        Xs2aAccountAccess xs2aAccountAccess = this.getXs2aAccountAccess(existingAccess, accounts, transactions, balances, ownerName, additionalInformationAccess);
        return this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(xs2aAccountAccess));
    }

    public CmsResponse<AccountConsent> updateCardAccountReferences(String consentId, Xs2aAccountAccess existingAccess, List<Xs2aCardAccountDetails> accountDetails) {
        ArrayList<AccountReference> accounts = new ArrayList<AccountReference>();
        ArrayList<AccountReference> transactions = new ArrayList<AccountReference>();
        ArrayList<AccountReference> balances = new ArrayList<AccountReference>();
        ArrayList<AccountReference> ownerName = new ArrayList<AccountReference>();
        AdditionalInformationAccess additionalInformationAccess = existingAccess.getAdditionalInformationAccess();
        if (existingAccess.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS) {
            accounts.addAll(this.enrichCardAccountReferencesGlobal(accountDetails));
            transactions.addAll(this.enrichCardAccountReferencesGlobal(accountDetails));
            balances.addAll(this.enrichCardAccountReferencesGlobal(accountDetails));
        } else {
            for (Xs2aCardAccountDetails accountDetail : accountDetails) {
                accounts.addAll(this.enrichCardAccountReferences(accountDetail, existingAccess.getAccounts()));
                balances.addAll(this.enrichCardAccountReferences(accountDetail, existingAccess.getBalances()));
                transactions.addAll(this.enrichCardAccountReferences(accountDetail, existingAccess.getTransactions()));
            }
        }
        for (Xs2aCardAccountDetails accountDetail : accountDetails) {
            if (additionalInformationAccess == null || additionalInformationAccess.getOwnerName() == null) continue;
            ownerName.addAll(this.enrichCardAccountReferences(accountDetail, additionalInformationAccess.getOwnerName()));
        }
        Xs2aAccountAccess xs2aAccountAccess = this.getXs2aAccountAccess(existingAccess, accounts, transactions, balances, ownerName, additionalInformationAccess);
        return this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(xs2aAccountAccess));
    }

    private Xs2aAccountAccess getXs2aAccountAccess(Xs2aAccountAccess existingAccess, List<AccountReference> accounts, List<AccountReference> transactions, List<AccountReference> balances, List<AccountReference> ownerName, AdditionalInformationAccess additionalInformationAccess) {
        return new Xs2aAccountAccess(accounts, balances, transactions, existingAccess.getAvailableAccounts(), existingAccess.getAllPsd2(), existingAccess.getAvailableAccountsWithBalance(), Optional.ofNullable(additionalInformationAccess).map(info -> new AdditionalInformationAccess(ownerName)).orElse(null));
    }

    private List<AccountReference> enrichAccountReferences(Xs2aAccountDetails xs2aAccountDetails, List<AccountReference> accountReferenceList) {
        return accountReferenceList.stream().filter(ar -> ar.getUsedAccountReferenceSelector().equals((Object)xs2aAccountDetails.getAccountSelector())).map(ar -> new AccountReference(ar.getUsedAccountReferenceSelector().getAccountReferenceType(), ar.getUsedAccountReferenceSelector().getAccountValue(), ar.getCurrency(), xs2aAccountDetails.getResourceId(), xs2aAccountDetails.getAspspAccountId())).collect(Collectors.toList());
    }

    private List<AccountReference> enrichCardAccountReferences(Xs2aCardAccountDetails xs2aAccountDetails, List<AccountReference> accountReferenceList) {
        return accountReferenceList.stream().filter(ar -> this.cardAccountHandler.areAccountsEqual(xs2aAccountDetails, (AccountReference)ar)).map(ar -> new AccountReference(ar.getUsedAccountReferenceSelector().getAccountReferenceType(), ar.getUsedAccountReferenceSelector().getAccountValue(), ar.getCurrency(), xs2aAccountDetails.getResourceId(), xs2aAccountDetails.getAspspAccountId())).collect(Collectors.toList());
    }

    private List<AccountReference> enrichAccountReferencesGlobal(List<Xs2aAccountDetails> xs2aAccountDetails) {
        return xs2aAccountDetails.stream().map(ad -> new AccountReference(ad.getAccountSelector().getAccountReferenceType(), ad.getAccountSelector().getAccountValue(), ad.getCurrency(), ad.getResourceId(), ad.getAspspAccountId())).collect(Collectors.toList());
    }

    private List<AccountReference> enrichCardAccountReferencesGlobal(List<Xs2aCardAccountDetails> xs2aAccountDetails) {
        return xs2aAccountDetails.stream().map(ad -> new AccountReference(AccountReferenceType.MASKED_PAN, ad.getMaskedPan(), ad.getCurrency(), ad.getResourceId(), ad.getAspspAccountId())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"aisConsentService", "consentMapper", "cardAccountHandler"})
    public AccountReferenceInConsentUpdater(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, CardAccountHandler cardAccountHandler) {
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.cardAccountHandler = cardAccountHandler;
    }
}

