/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.processor.service;

import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.CommonDecoupledAisService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.authorization.processor.service.BaseAuthorisationProcessorService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AisAuthorisationProcessorServiceImpl
extends BaseAuthorisationProcessorService {
    private static final String CONSENT_NOT_FOUND_LOG_MESSAGE = "Apply authorisation when update consent PSU data has failed. Consent not found by id.";
    private final List<AisAuthorizationService> services;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentSpi aisConsentSpi;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final CommonDecoupledAisService commonDecoupledAisService;
    private final AisScaAuthorisationService aisScaAuthorisationService;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;

    public AisAuthorisationProcessorServiceImpl(List<AisAuthorizationService> services, Xs2aAisConsentService aisConsentService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper, CommonDecoupledAisService commonDecoupledAisService, AisScaAuthorisationService aisScaAuthorisationService, Xs2aToSpiPsuDataMapper psuDataMapper) {
        this.services = services;
        this.aisConsentService = aisConsentService;
        this.aisConsentSpi = aisConsentSpi;
        this.aisConsentMapper = aisConsentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.commonDecoupledAisService = commonDecoupledAisService;
        this.aisScaAuthorisationService = aisScaAuthorisationService;
        this.psuDataMapper = psuDataMapper;
    }

    @Override
    public void updateAuthorisation(AuthorisationProcessorRequest request, AuthorisationProcessorResponse response) {
        AisAuthorizationService authorizationService = this.getService(request.getScaApproach());
        authorizationService.updateConsentPsuData(request.getUpdateAuthorisationRequest(), response);
    }

    @Override
    public AuthorisationProcessorResponse doScaReceived(AuthorisationProcessorRequest authorisationProcessorRequest) {
        return this.doScaPsuIdentified(authorisationProcessorRequest);
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuIdentified(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        return request.isUpdatePsuIdentification() ? this.applyIdentification(authorisationProcessorRequest) : this.applyAuthorisation(authorisationProcessorRequest);
    }

    @Override
    public AuthorisationProcessorResponse doScaPsuAuthenticated(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        PsuIdData psuData = this.extractPsuIdData(request, authorisationProcessorRequest.getAuthorisation());
        AccountConsent accountConsent = accountConsentOptional.get();
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(accountConsent);
        String authenticationMethodId = request.getAuthenticationMethodId();
        if (this.isDecoupledApproach(request.getAuthorisationId(), authenticationMethodId)) {
            this.aisConsentService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.commonDecoupledAisService.proceedDecoupledApproach(request.getBusinessObjectId(), request.getAuthorisationId(), spiAccountConsent, authenticationMethodId, psuData);
        }
        return this.proceedEmbeddedApproach(authorisationProcessorRequest, authenticationMethodId, spiAccountConsent, psuData);
    }

    @Override
    public AuthorisationProcessorResponse doScaMethodSelected(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        PsuIdData psuData = this.extractPsuIdData(request, authorisationProcessorRequest.getAuthorisation());
        SpiResponse spiResponse = this.aisConsentSpi.verifyScaAuthorisation(this.spiContextDataProvider.provideWithPsuIdData(psuData), this.aisConsentMapper.mapToSpiScaConfirmation(request, psuData), this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, "Verify SCA authorisation failed when update PSU data.");
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.aisConsentService.updateConsentAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        ConsentStatus responseConsentStatus = ((SpiVerifyScaAuthorisationResponse)spiResponse.getPayload()).getConsentStatus();
        if (ConsentStatus.PARTIALLY_AUTHORISED == responseConsentStatus && !accountConsent.isMultilevelScaRequired()) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, true);
        }
        if (accountConsent.getConsentStatus() != responseConsentStatus) {
            this.aisConsentService.updateConsentStatus(consentId, responseConsentStatus);
        }
        this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
        return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, request.getAuthorisationId(), psuData);
    }

    @Override
    public AuthorisationProcessorResponse doScaFinalised(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
    }

    private UpdateConsentPsuDataResponse proceedEmbeddedApproach(AuthorisationProcessorRequest authorisationProcessorRequest, String authenticationMethodId, SpiAccountConsent spiAccountConsent, PsuIdData psuData) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        SpiResponse spiResponse = this.aisConsentSpi.requestAuthorisationCode(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationMethodId, (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getBusinessObjectId()));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Proceed embedded approach when performs authorisation depending on selected SCA method has failed.");
            Optional first = errorHolder.getFirstErrorCode();
            if (first.isPresent() && first.get() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.aisConsentService.updateConsentAuthorisationStatus(request.getAuthorisationId(), ScaStatus.FAILED);
            }
            return new UpdateConsentPsuDataResponse(errorHolder, request.getBusinessObjectId(), request.getAuthorisationId(), psuData);
        }
        SpiAuthorizationCodeResult authorizationCodeResult = (SpiAuthorizationCodeResult)spiResponse.getPayload();
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, request.getBusinessObjectId(), request.getAuthorisationId(), psuData);
        response.setChosenScaMethod(authorizationCodeResult.getSelectedScaMethod());
        response.setChallengeData(authorizationCodeResult.getChallengeData());
        return response;
    }

    private AisAuthorizationService getService(ScaApproach scaApproach) {
        return this.services.stream().filter(s -> s.getScaApproachServiceType() == scaApproach).findFirst().orElseThrow(() -> new IllegalArgumentException("Ais authorisation service was not found for approach " + scaApproach));
    }

    private UpdateConsentPsuDataResponse applyAuthorisation(AuthorisationProcessorRequest authorisationProcessorRequest) {
        SpiPsuData spiPsuData;
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        String consentId = request.getBusinessObjectId();
        String authorisationId = request.getAuthorisationId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, CONSENT_NOT_FOUND_LOG_MESSAGE);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, request.getPsuData());
        }
        Authorisation authorisation = authorisationProcessorRequest.getAuthorisation();
        PsuIdData psuData = this.extractPsuIdData(request, authorisation);
        AccountConsent accountConsent = accountConsentOptional.get();
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(accountConsent);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiResponse authorisationStatusSpiResponse = this.aisConsentSpi.authorisePsu(spiContextData, spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData), request.getPassword(), (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (authorisationStatusSpiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(authorisationStatusSpiResponse, ServiceType.AIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Authorise PSU when apply authorisation has failed.");
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        if (((SpiPsuAuthorisationResponse)authorisationStatusSpiResponse.getPayload()).getSpiAuthorisationStatus() == SpiAuthorisationStatus.FAILURE) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_401).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PSU_CREDENTIALS_INVALID)}).build();
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Authorise PSU when apply authorisation has failed. PSU credentials invalid.");
            this.aisConsentService.updateConsentAuthorisationStatus(authorisationId, ScaStatus.FAILED);
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        if (this.aisScaAuthorisationService.isOneFactorAuthorisation(accountConsent)) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.VALID);
            return new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, authorisationId, psuData);
        }
        if (authorisation.getChosenScaApproach() == ScaApproach.DECOUPLED) {
            return this.commonDecoupledAisService.proceedDecoupledApproach(consentId, authorisationId, spiAccountConsent, psuData);
        }
        SpiResponse spiResponse = this.aisConsentSpi.requestAvailableScaMethods(this.spiContextDataProvider.provideWithPsuIdData(psuData), (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Request available SCA methods when apply authorisation has failed.");
            return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
        }
        List availableScaMethods = ((SpiAvailableScaMethodsResponse)spiResponse.getPayload()).getAvailableScaMethods();
        if (CollectionUtils.isNotEmpty((Collection)availableScaMethods)) {
            this.aisConsentService.saveAuthenticationMethods(authorisationId, availableScaMethods);
            if (this.isMultipleScaMethods(availableScaMethods)) {
                return this.createResponseForMultipleAvailableMethods(availableScaMethods, authorisationId, consentId, psuData);
            }
            return this.createResponseForOneAvailableMethod(authorisationProcessorRequest, spiAccountConsent, (AuthenticationObject)availableScaMethods.get(0), psuData);
        }
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SCA_METHOD_UNKNOWN)}).build();
        this.writeErrorLog(authorisationProcessorRequest, psuData, errorHolder, "Apply authorisation has failed. Consent was rejected because PSU has no available SCA methods.");
        this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
        this.aisConsentService.updateConsentAuthorisationStatus(authorisationId, ScaStatus.FAILED);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuData);
    }

    private UpdateConsentPsuDataResponse createResponseForMultipleAvailableMethods(List<AuthenticationObject> availableScaMethods, String authorisationId, String consentId, PsuIdData psuIdData) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.PSUAUTHENTICATED, consentId, authorisationId, psuIdData);
        response.setAvailableScaMethods(availableScaMethods);
        return response;
    }

    private UpdateConsentPsuDataResponse createResponseForOneAvailableMethod(AuthorisationProcessorRequest authorisationProcessorRequest, SpiAccountConsent spiAccountConsent, AuthenticationObject scaMethod, PsuIdData psuData) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        if (scaMethod.isDecoupled()) {
            this.aisConsentService.updateScaApproach(request.getAuthorisationId(), ScaApproach.DECOUPLED);
            return this.commonDecoupledAisService.proceedDecoupledApproach(request.getBusinessObjectId(), request.getAuthorisationId(), spiAccountConsent, scaMethod.getAuthenticationMethodId(), psuData);
        }
        return this.proceedEmbeddedApproach(authorisationProcessorRequest, scaMethod.getAuthenticationMethodId(), spiAccountConsent, psuData);
    }

    private UpdateConsentPsuDataResponse applyIdentification(AuthorisationProcessorRequest authorisationProcessorRequest) {
        UpdateAuthorisationRequest request = authorisationProcessorRequest.getUpdateAuthorisationRequest();
        if (!this.isPsuExist(request.getPsuData())) {
            ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NO_PSU)}).build();
            this.writeErrorLog(authorisationProcessorRequest, request.getPsuData(), errorHolder, "Apply identification when update consent PSU data has failed. No PSU data available in request.");
            return new UpdateConsentPsuDataResponse(errorHolder, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
        }
        return new UpdateConsentPsuDataResponse(ScaStatus.PSUIDENTIFIED, request.getBusinessObjectId(), request.getAuthorisationId(), request.getPsuData());
    }

    private boolean isDecoupledApproach(String authorisationId, String authenticationMethodId) {
        return this.aisConsentService.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
    }
}

