/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class AisScaAuthorisationService {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public boolean isOneFactorAuthorisation(AccountConsent accountConsent) {
        if (!accountConsent.isOneAccessType()) {
            return false;
        }
        if (accountConsent.isConsentForAllAvailableAccounts()) {
            return !this.aspspProfileServiceWrapper.isScaByOneTimeAvailableAccountsConsentRequired();
        }
        if (accountConsent.isGlobalConsent()) {
            return !this.aspspProfileServiceWrapper.isScaByOneTimeGlobalConsentRequired();
        }
        return false;
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public AisScaAuthorisationService(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

