/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.CardAccountHandler;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceReportMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetCardBalancesReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountBalanceRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CardAccountSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardAccountBalanceService {
    private static final Logger log = LoggerFactory.getLogger(CardAccountBalanceService.class);
    private final CardAccountSpi cardAccountSpi;
    private final SpiToXs2aBalanceReportMapper balanceReportMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetCardBalancesReportValidator getCardBalancesReportValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;
    private final CardAccountHandler cardAccountHandler;

    public ResponseObject<Xs2aBalancesReport> getBalancesReport(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_CARD_BALANCE_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            log.info("Account-ID [{}], Consent-ID [{}]. Get card balances report failed. Account consent not found by ID", (Object)accountId, (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForCommonAccountBalanceRequest(accountId, requestUri, accountConsent);
        if (validationResult.isNotValid()) {
            log.info("Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get card balances report - validation failed: {}", new Object[]{accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<List<SpiAccountBalance>> spiResponse = this.getSpiResponse(accountConsent, consentId, accountId);
        if (spiResponse.hasError()) {
            return this.checkSpiResponse(consentId, accountId, spiResponse);
        }
        this.loggingContextService.storeConsentStatus(accountConsent.getConsentStatus());
        return this.getXs2aBalancesReportResponseObject(accountConsent, accountId, consentId, requestUri, (List)spiResponse.getPayload());
    }

    private ValidationResult getValidationResultForCommonAccountBalanceRequest(String accountId, String requestUri, AccountConsent accountConsent) {
        return this.getCardBalancesReportValidator.validate(new GetCardAccountBalanceRequestObject(accountConsent, accountId, requestUri));
    }

    private SpiResponse<List<SpiAccountBalance>> getSpiResponse(AccountConsent accountConsent, String consentId, String accountId) {
        Xs2aAccountAccess access = accountConsent.getAspspAccess();
        SpiAccountReference requestedAccountReference = this.accountHelperService.findAccountReference(access.getBalances(), accountId);
        return this.cardAccountSpi.requestCardBalancesForAccount(this.accountHelperService.getSpiContextData(), requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Xs2aBalancesReport> checkSpiResponse(String consentId, String accountId, SpiResponse<List<SpiAccountBalance>> spiResponse) {
        log.info("Account-ID [{}], Consent-ID: [{}]. Get card balances report failed: error on SPI level", (Object)accountId, (Object)consentId);
        return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
    }

    @NotNull
    private ResponseObject<Xs2aBalancesReport> getXs2aBalancesReportResponseObject(AccountConsent accountConsent, String accountId, String consentId, String requestUri, List<SpiAccountBalance> payload) {
        Xs2aAccountAccess access = accountConsent.getAspspAccess();
        List<AccountReference> balances = access.getBalances();
        if (this.hasNoAccessToCardSource(balances)) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_INVALID)).build();
        }
        AccountReference maskedAccountReference = this.getMaskedAccountReference(accountId, access.getBalances());
        Xs2aBalancesReport balancesReport = this.balanceReportMapper.mapToXs2aBalancesReport(maskedAccountReference, payload);
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.BALANCE, response), requestUri, this.accountHelperService.needsToUpdateUsage(accountConsent), accountId, null);
        return response;
    }

    private AccountReference getMaskedAccountReference(String accountId, List<AccountReference> balances) {
        AccountReference filteredAccountReference = this.filterAccountReference(balances, accountId);
        if (filteredAccountReference != null && StringUtils.isNotBlank((CharSequence)filteredAccountReference.getPan())) {
            String maskedPan = this.cardAccountHandler.hidePanInAccountReference(filteredAccountReference.getPan());
            filteredAccountReference.setPan(null);
            filteredAccountReference.setMaskedPan(maskedPan);
        }
        return filteredAccountReference;
    }

    private AccountReference filterAccountReference(List<AccountReference> references, String resourceId) {
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().orElse(null);
    }

    private boolean hasNoAccessToCardSource(List<AccountReference> references) {
        return references.stream().allMatch(AccountReference::isNotCardAccount);
    }

    @ConstructorProperties(value={"cardAccountSpi", "balanceReportMapper", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "spiErrorMapper", "getCardBalancesReportValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService", "cardAccountHandler"})
    public CardAccountBalanceService(CardAccountSpi cardAccountSpi, SpiToXs2aBalanceReportMapper balanceReportMapper, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetCardBalancesReportValidator getCardBalancesReportValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService, CardAccountHandler cardAccountHandler) {
        this.cardAccountSpi = cardAccountSpi;
        this.balanceReportMapper = balanceReportMapper;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getCardBalancesReportValidator = getCardBalancesReportValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
        this.cardAccountHandler = cardAccountHandler;
    }
}

