/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;

@ApiModel(description="CardTransactions information", value="TransactionsCreditorResponse")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CardTransaction {
    @ApiModelProperty(value="Can be used as access-ID in the API, where more details on an transaction is offered.", required=false, example="1234567")
    private String cardTransactionId;
    @ApiModelProperty(value="Identification of the Terminal, where the card has been used.", example="1234567")
    private String terminalId;
    @ApiModelProperty(value="Date of the actual card transaction", example="1234567")
    private LocalDate transactionDate;
    @ApiModelProperty(value="Booking date of the related booking on the card account", example="1234567")
    private LocalDate bookingDate;
    @ApiModelProperty(value="The amount of the transaction as billed to the card account.", example="1234567")
    private Xs2aAmount transactionAmount;
    @ApiModelProperty(value="For card accounts, only one exchange rate is used.")
    private List<Xs2aExchangeRate> currencyExchange;
    @ApiModelProperty(value="Original amount of the transaction at the Point of Interaction in orginal currency", example="1234567")
    private Xs2aAmount originalAmount;
    @ApiModelProperty(value="Any fee related to the transaction in billing currency.", example="1234567")
    private Xs2aAmount markupFee;
    @ApiModelProperty(value="Percentage of the involved transaction fee in relation to the billing amount.", example="1234567")
    private String markupFeePercentage;
    @ApiModelProperty(value="Identification of the Card Acceptor (e.g. merchant) as given in the related card transaction.", example="1234567")
    private String cardAcceptorId;
    @ApiModelProperty(value="Address of the Card Acceptor as given in the related card transaction.", example="1234567")
    private Xs2aAddress cardAcceptorAddress;
    @ApiModelProperty(value="Card Acceptor Category Code of the Card Acceptor as given in the related card transaction.", example="1234567")
    private String merchantCategoryCode;
    @ApiModelProperty(value="The masked PAN of the card used in the transaction.", example="1234567")
    private String maskedPAN;
    @ApiModelProperty(value="Additional details given for the related card transactions.", example="1234567")
    private String transactionDetails;
    @ApiModelProperty(value="Flag indicating whether the underlying card transaction is already invoiced.", example="1234567")
    private Boolean invoiced;
    @ApiModelProperty(value="Proprietary bank transaction code as used within a community or within an ASPSP e.g. for MT94x based transaction reports", example="1234567")
    private String proprietaryBankTransactionCode;

    public String getCardTransactionId() {
        return this.cardTransactionId;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public Xs2aAmount getTransactionAmount() {
        return this.transactionAmount;
    }

    public List<Xs2aExchangeRate> getCurrencyExchange() {
        return this.currencyExchange;
    }

    public Xs2aAmount getOriginalAmount() {
        return this.originalAmount;
    }

    public Xs2aAmount getMarkupFee() {
        return this.markupFee;
    }

    public String getMarkupFeePercentage() {
        return this.markupFeePercentage;
    }

    public String getCardAcceptorId() {
        return this.cardAcceptorId;
    }

    public Xs2aAddress getCardAcceptorAddress() {
        return this.cardAcceptorAddress;
    }

    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public String getMaskedPAN() {
        return this.maskedPAN;
    }

    public String getTransactionDetails() {
        return this.transactionDetails;
    }

    public Boolean getInvoiced() {
        return this.invoiced;
    }

    public String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setCardTransactionId(String cardTransactionId) {
        this.cardTransactionId = cardTransactionId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public void setTransactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public void setTransactionAmount(Xs2aAmount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public void setCurrencyExchange(List<Xs2aExchangeRate> currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public void setOriginalAmount(Xs2aAmount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public void setMarkupFee(Xs2aAmount markupFee) {
        this.markupFee = markupFee;
    }

    public void setMarkupFeePercentage(String markupFeePercentage) {
        this.markupFeePercentage = markupFeePercentage;
    }

    public void setCardAcceptorId(String cardAcceptorId) {
        this.cardAcceptorId = cardAcceptorId;
    }

    public void setCardAcceptorAddress(Xs2aAddress cardAcceptorAddress) {
        this.cardAcceptorAddress = cardAcceptorAddress;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public void setMaskedPAN(String maskedPAN) {
        this.maskedPAN = maskedPAN;
    }

    public void setTransactionDetails(String transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CardTransaction)) {
            return false;
        }
        CardTransaction other = (CardTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cardTransactionId = this.getCardTransactionId();
        String other$cardTransactionId = other.getCardTransactionId();
        if (this$cardTransactionId == null ? other$cardTransactionId != null : !this$cardTransactionId.equals(other$cardTransactionId)) {
            return false;
        }
        String this$terminalId = this.getTerminalId();
        String other$terminalId = other.getTerminalId();
        if (this$terminalId == null ? other$terminalId != null : !this$terminalId.equals(other$terminalId)) {
            return false;
        }
        LocalDate this$transactionDate = this.getTransactionDate();
        LocalDate other$transactionDate = other.getTransactionDate();
        if (this$transactionDate == null ? other$transactionDate != null : !((Object)this$transactionDate).equals(other$transactionDate)) {
            return false;
        }
        LocalDate this$bookingDate = this.getBookingDate();
        LocalDate other$bookingDate = other.getBookingDate();
        if (this$bookingDate == null ? other$bookingDate != null : !((Object)this$bookingDate).equals(other$bookingDate)) {
            return false;
        }
        Xs2aAmount this$transactionAmount = this.getTransactionAmount();
        Xs2aAmount other$transactionAmount = other.getTransactionAmount();
        if (this$transactionAmount == null ? other$transactionAmount != null : !this$transactionAmount.equals(other$transactionAmount)) {
            return false;
        }
        List<Xs2aExchangeRate> this$currencyExchange = this.getCurrencyExchange();
        List<Xs2aExchangeRate> other$currencyExchange = other.getCurrencyExchange();
        if (this$currencyExchange == null ? other$currencyExchange != null : !((Object)this$currencyExchange).equals(other$currencyExchange)) {
            return false;
        }
        Xs2aAmount this$originalAmount = this.getOriginalAmount();
        Xs2aAmount other$originalAmount = other.getOriginalAmount();
        if (this$originalAmount == null ? other$originalAmount != null : !this$originalAmount.equals(other$originalAmount)) {
            return false;
        }
        Xs2aAmount this$markupFee = this.getMarkupFee();
        Xs2aAmount other$markupFee = other.getMarkupFee();
        if (this$markupFee == null ? other$markupFee != null : !this$markupFee.equals(other$markupFee)) {
            return false;
        }
        String this$markupFeePercentage = this.getMarkupFeePercentage();
        String other$markupFeePercentage = other.getMarkupFeePercentage();
        if (this$markupFeePercentage == null ? other$markupFeePercentage != null : !this$markupFeePercentage.equals(other$markupFeePercentage)) {
            return false;
        }
        String this$cardAcceptorId = this.getCardAcceptorId();
        String other$cardAcceptorId = other.getCardAcceptorId();
        if (this$cardAcceptorId == null ? other$cardAcceptorId != null : !this$cardAcceptorId.equals(other$cardAcceptorId)) {
            return false;
        }
        Xs2aAddress this$cardAcceptorAddress = this.getCardAcceptorAddress();
        Xs2aAddress other$cardAcceptorAddress = other.getCardAcceptorAddress();
        if (this$cardAcceptorAddress == null ? other$cardAcceptorAddress != null : !this$cardAcceptorAddress.equals(other$cardAcceptorAddress)) {
            return false;
        }
        String this$merchantCategoryCode = this.getMerchantCategoryCode();
        String other$merchantCategoryCode = other.getMerchantCategoryCode();
        if (this$merchantCategoryCode == null ? other$merchantCategoryCode != null : !this$merchantCategoryCode.equals(other$merchantCategoryCode)) {
            return false;
        }
        String this$maskedPAN = this.getMaskedPAN();
        String other$maskedPAN = other.getMaskedPAN();
        if (this$maskedPAN == null ? other$maskedPAN != null : !this$maskedPAN.equals(other$maskedPAN)) {
            return false;
        }
        String this$transactionDetails = this.getTransactionDetails();
        String other$transactionDetails = other.getTransactionDetails();
        if (this$transactionDetails == null ? other$transactionDetails != null : !this$transactionDetails.equals(other$transactionDetails)) {
            return false;
        }
        Boolean this$invoiced = this.getInvoiced();
        Boolean other$invoiced = other.getInvoiced();
        if (this$invoiced == null ? other$invoiced != null : !((Object)this$invoiced).equals(other$invoiced)) {
            return false;
        }
        String this$proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        String other$proprietaryBankTransactionCode = other.getProprietaryBankTransactionCode();
        return !(this$proprietaryBankTransactionCode == null ? other$proprietaryBankTransactionCode != null : !this$proprietaryBankTransactionCode.equals(other$proprietaryBankTransactionCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CardTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cardTransactionId = this.getCardTransactionId();
        result = result * 59 + ($cardTransactionId == null ? 43 : $cardTransactionId.hashCode());
        String $terminalId = this.getTerminalId();
        result = result * 59 + ($terminalId == null ? 43 : $terminalId.hashCode());
        LocalDate $transactionDate = this.getTransactionDate();
        result = result * 59 + ($transactionDate == null ? 43 : ((Object)$transactionDate).hashCode());
        LocalDate $bookingDate = this.getBookingDate();
        result = result * 59 + ($bookingDate == null ? 43 : ((Object)$bookingDate).hashCode());
        Xs2aAmount $transactionAmount = this.getTransactionAmount();
        result = result * 59 + ($transactionAmount == null ? 43 : $transactionAmount.hashCode());
        List<Xs2aExchangeRate> $currencyExchange = this.getCurrencyExchange();
        result = result * 59 + ($currencyExchange == null ? 43 : ((Object)$currencyExchange).hashCode());
        Xs2aAmount $originalAmount = this.getOriginalAmount();
        result = result * 59 + ($originalAmount == null ? 43 : $originalAmount.hashCode());
        Xs2aAmount $markupFee = this.getMarkupFee();
        result = result * 59 + ($markupFee == null ? 43 : $markupFee.hashCode());
        String $markupFeePercentage = this.getMarkupFeePercentage();
        result = result * 59 + ($markupFeePercentage == null ? 43 : $markupFeePercentage.hashCode());
        String $cardAcceptorId = this.getCardAcceptorId();
        result = result * 59 + ($cardAcceptorId == null ? 43 : $cardAcceptorId.hashCode());
        Xs2aAddress $cardAcceptorAddress = this.getCardAcceptorAddress();
        result = result * 59 + ($cardAcceptorAddress == null ? 43 : $cardAcceptorAddress.hashCode());
        String $merchantCategoryCode = this.getMerchantCategoryCode();
        result = result * 59 + ($merchantCategoryCode == null ? 43 : $merchantCategoryCode.hashCode());
        String $maskedPAN = this.getMaskedPAN();
        result = result * 59 + ($maskedPAN == null ? 43 : $maskedPAN.hashCode());
        String $transactionDetails = this.getTransactionDetails();
        result = result * 59 + ($transactionDetails == null ? 43 : $transactionDetails.hashCode());
        Boolean $invoiced = this.getInvoiced();
        result = result * 59 + ($invoiced == null ? 43 : ((Object)$invoiced).hashCode());
        String $proprietaryBankTransactionCode = this.getProprietaryBankTransactionCode();
        result = result * 59 + ($proprietaryBankTransactionCode == null ? 43 : $proprietaryBankTransactionCode.hashCode());
        return result;
    }

    public String toString() {
        return "CardTransaction(cardTransactionId=" + this.getCardTransactionId() + ", terminalId=" + this.getTerminalId() + ", transactionDate=" + this.getTransactionDate() + ", bookingDate=" + this.getBookingDate() + ", transactionAmount=" + this.getTransactionAmount() + ", currencyExchange=" + this.getCurrencyExchange() + ", originalAmount=" + this.getOriginalAmount() + ", markupFee=" + this.getMarkupFee() + ", markupFeePercentage=" + this.getMarkupFeePercentage() + ", cardAcceptorId=" + this.getCardAcceptorId() + ", cardAcceptorAddress=" + this.getCardAcceptorAddress() + ", merchantCategoryCode=" + this.getMerchantCategoryCode() + ", maskedPAN=" + this.getMaskedPAN() + ", transactionDetails=" + this.getTransactionDetails() + ", invoiced=" + this.getInvoiced() + ", proprietaryBankTransactionCode=" + this.getProprietaryBankTransactionCode() + ")";
    }
}

